/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.config.PrefillRequestForms;
import com.tcs.efiling.form.main.CommonUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.PrefillFormDialogController;
import com.tcs.efiling.form.main.ValidationCacher;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.web.WebEngine;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrefillUtil
extends Task<Void> {
    private static final Logger LOG = Logger.getLogger(PrefillUtil.class);
    static SOAPConnectionFactory soapConnectionFactory;
    static SOAPConnection soapConnection;
    static String url;
    String xml;
    MainController mainController;
    PrefillFormDialogController prefillController;
    File itrFile;
    String error;
    String result = "";
    File pfxFile;
    Node itrNode;
    WebEngine itrEngine;
    static JAXBContext prefillContext;
    static PrefillRequestForms prefillRequest;
    static Map<String, List<String>> XML_VALUES;

    public PrefillUtil() {
    }

    public PrefillUtil(String userId, String password, String dob, String formName, String asstYear, String addrFlag) {
        prefillRequest.setUserId(userId);
        prefillRequest.setPassword(password);
        prefillRequest.setDob(dob);
        prefillRequest.setFormName(formName);
        prefillRequest.setAsstYear(asstYear);
        prefillRequest.setAddrFlag(addrFlag);
    }

    public static void init() {
        try {
            soapConnectionFactory = SOAPConnectionFactory.newInstance();
            soapConnection = soapConnectionFactory.createConnection();
            url = FormConfigUtil.getConfigProperty("webservice.url");
            prefillContext = JAXBContext.newInstance((Class[])new Class[]{PrefillRequestForms.class});
            LOG.info("webservie url: " + url);
        }
        catch (Exception e) {
            LOG.error("Error in init", e);
        }
    }

    protected Void call() throws Exception {
        try {
            LOG.info("call starts ");
            long time1 = System.currentTimeMillis();
            this.sendRequest();
            long time2 = System.currentTimeMillis();
            LOG.info("call ends Time taken:" + (time2 - time1));
        }
        catch (Exception e) {
            LOG.error("Error in call", e);
        }
        return null;
    }

    public void sendRequest() {
        LOG.info("sendRequest starts");
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage request = messageFactory.createMessage();
            SOAPPart soapPart = request.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody soapBody = envelope.getBody();
            Marshaller marshaller = prefillContext.createMarshaller();
            marshaller.marshal((Object)prefillRequest, (Node)soapBody);
            CommonUtil.writeSoapToLog(LOG, request);
            SOAPMessage response = soapConnection.call(request, (Object)url);
            CommonUtil.writeSoapToLog(LOG, response);
            SOAPBody resBody = response.getSOAPPart().getEnvelope().getBody();
            SOAPFault soapFault = resBody.getFault();
            LOG.info("Soap fault: " + soapFault);
            if (soapFault != null) {
                String faultActor = soapFault.getFaultActor();
                String faultString = soapFault.getFaultString();
                String faultCode = soapFault.getFaultCode();
                this.error = "Fault: " + faultString;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PrefillUtil.this.prefillController.progress.setProgress(1.0);
                        PrefillUtil.this.prefillController.errorText.setText(PrefillUtil.this.error);
                    }
                });
            } else {
                this.itrNode = resBody.getElementsByTagName("PrefillResponseXML").item(0);
                XML_VALUES.clear();
                PrefillUtil.iterateNode2(this.itrNode, "FORMBB");
                LOG.info("XML_VALUES: " + XML_VALUES);
                LOG.info("mainController.itrName: " + MainController.itrName);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (String key : XML_VALUES.keySet()) {
                            List<String> vals = XML_VALUES.get(key);
                            for (int i = 0; i < vals.size(); ++i) {
                                String val = vals.get(i);
                                try {
                                    if (key.indexOf("[0]") != -1) {
                                        PrefillUtil.this.itrEngine.executeScript("setValues('" + key.replace("[0]", "[" + i + "]") + "','" + val + "','0')");
                                        continue;
                                    }
                                    PrefillUtil.this.itrEngine.executeScript("setValues('" + key + "','" + val + "','0')");
                                    continue;
                                }
                                catch (Exception e) {
                                    LOG.error("Error setting " + key + " val:" + val);
                                }
                            }
                        }
                        PrefillUtil.this.itrEngine.executeScript("prefill();");
                        PrefillUtil.this.prefillController.progress.setProgress(1.0);
                        PrefillUtil.this.prefillController.cancel();
                        PrefillUtil.this.mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("msg.prefill.success"), false);
                        LOG.info("Prefill done successfully");
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Error in sendRequest: ", e);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PrefillUtil.this.mainController.getVaidationBar().setProgress(1.0);
                    PrefillUtil.this.mainController.generateErrorDialog(e.getMessage(), true);
                }
            });
        }
        LOG.info("sendrequest ends");
    }

    public static void iterateNode2(Node node, String nodeName) {
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                String name = nodeTemp.getNodeName();
                if (name.contains(":")) {
                    name = name.substring(name.lastIndexOf(":") + 1);
                }
                if (nodeTemp.getNodeType() != 3) {
                    PrefillUtil.iterateNode2(nodeTemp, nodeName + "/" + name);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null && node.getNodeType() == 1 && node.getChildNodes().getLength() <= 1) {
            String fieldName = ValidationCacher.XPATH_TO_FIELD.get(nodeName);
            String val = node.getTextContent();
            if (val.matches("^[0-9]{4}(-)[0-9]{2}(-)[0-9]{2}$")) {
                val = val.substring(8) + "/" + val.substring(5, 7) + "/" + val.substring(0, 4);
            }
            LOG.debug("fieldname: " + fieldName + ",nodeName: " + nodeName + ",val: " + val);
            if (fieldName != null) {
                if (XML_VALUES.containsKey(fieldName)) {
                    List<String> oldList = XML_VALUES.get(fieldName);
                    oldList.add(val);
                } else {
                    ArrayList<String> newList = new ArrayList<String>();
                    newList.add(val);
                    XML_VALUES.put(fieldName, newList);
                }
            }
        }
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public PrefillFormDialogController getPrefillController() {
        return this.prefillController;
    }

    public void setPrefillController(PrefillFormDialogController prefillController) {
        this.prefillController = prefillController;
    }

    public WebEngine getItrEngine() {
        return this.itrEngine;
    }

    public void setItrEngine(WebEngine itrEngine) {
        this.itrEngine = itrEngine;
    }

    static {
        url = "";
        prefillContext = null;
        prefillRequest = new PrefillRequestForms();
        PrefillUtil.init();
        XML_VALUES = new HashMap<String, List<String>>();
    }
}

