/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.MainLoader;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PreviewUtil
extends Task<Void> {
    public static final Logger LOG = Logger.getLogger(PreviewUtil.class);
    private File htmlFile;
    private File outputFile;
    private MainController mainController;
    static Map<String, String> FIELD_VALUE = new LinkedHashMap<String, String>();
    public static Document doc;

    protected Void call() throws Exception {
        try {
            String htmlFilePath = this.htmlFile.getAbsolutePath();
            LOG.info("call starts with File: " + htmlFilePath);
            long time1 = System.currentTimeMillis();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
            long time2 = System.currentTimeMillis();
            LOG.info("call ends : time taken: " + (time2 - time1));
        }
        catch (Exception e) {
            LOG.error("Error in call: ", e);
        }
        return null;
    }

    public static void addResources(String itrName, String asstYear, String version) throws Exception {
        LOG.info("Adding resources: ");
        NodeList nodeList = doc.getElementsByTagNameNS("*", "BODY");
        Element script = doc.createElement("script");
        script.setAttribute("type", "text/javascript");
        script.setAttribute("src", FormConfigUtil.getPreviewScript(itrName, asstYear, version));
        script.setTextContent("   ");
        Element css = doc.createElement("link");
        css.setAttribute("rel", "stylesheet");
        css.setAttribute("href", FormConfigUtil.getPreviewCss(itrName, asstYear, version));
        nodeList.item(0).appendChild(script);
        nodeList.item(0).appendChild(css);
    }

    public static void main(String[] args) throws Exception {
    }

    public static synchronized void addToFieldNameValue(WebEngine itrEngine) {
        FIELD_VALUE.clear();
        long time1 = System.currentTimeMillis();
        Object obj = itrEngine.executeScript("getNameValsPreview();");
        JSObject jsObject = (JSObject)obj;
        int len = (Integer)jsObject.getMember("length");
        for (int i = 0; i < len; ++i) {
            Object object = jsObject.getSlot(i);
            if (object instanceof String) continue;
            JSObject objj = (JSObject)object;
            FIELD_VALUE.put(objj.getMember("name").toString(), objj.getMember("value").toString());
        }
        long time2 = System.currentTimeMillis();
        LOG.debug("Time taken in addToFieldNameValue(): " + (time2 - time1));
    }

    public static void iterateNode(Node node) {
        Element element;
        String name;
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                if (nodeTemp.getNodeType() != 3) {
                    PreviewUtil.iterateNode(nodeTemp);
                }
                nodeCount = nodeList.getLength();
            }
        }
        if (node != null && node.getNodeType() == 1 && (name = (element = (Element)node).getAttribute("name")) != null && name.trim().length() != 0) {
            Element span;
            String val = FIELD_VALUE.get(name);
            if ("INPUT".equals(node.getNodeName())) {
                String type;
                if (name.indexOf("chosenCheckBox") == -1 && !(type = element.getAttribute("type")).equalsIgnoreCase("BUTTON") && !type.equalsIgnoreCase("HIDDEN")) {
                    Element span2;
                    Element spanEle = span2 = doc.createElement("span");
                    String rightAlignText = element.getAttribute("class");
                    if (rightAlignText.equalsIgnoreCase("rightAlign")) {
                        spanEle.setAttribute("class", "spanValRightAlign");
                    } else {
                        spanEle.setAttribute("class", "eFSpanVal");
                    }
                    span2.setTextContent(val);
                    node.getParentNode().appendChild(span2);
                }
                node.getParentNode().removeChild(node);
            } else if ("SELECT".equals(node.getNodeName())) {
                Element spanEle = span = doc.createElement("span");
                spanEle.setAttribute("class", "eFSpanVal");
                span.setTextContent(val);
                node.getParentNode().appendChild(span);
                node.getParentNode().removeChild(node);
            } else if ("TEXTAREA".equals(node.getNodeName())) {
                Element spanEle = span = doc.createElement("span");
                spanEle.setAttribute("class", "eFSpanVal");
                span.setTextContent(val);
                node.getParentNode().appendChild(span);
                node.getParentNode().removeChild(node);
            }
        }
    }

    public static void print(File htmlTempFile) {
        try {
            HostServices services = MainLoader.hostServices;
            services.showDocument(htmlTempFile.toURI().toURL().toExternalForm());
        }
        catch (Exception e) {
            LOG.error("Error in print; ", e);
        }
    }

    public File getHtmlFile() {
        return this.htmlFile;
    }

    public void setHtmlFile(File htmlFile) {
        this.htmlFile = htmlFile;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

