/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.CommonUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.UpdateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.stage.Stage;

public class UpdateController
implements Initializable {
    static final Logger LOG = Logger.getLogger(UpdateController.class);
    private Stage myDialogStage;
    static MainController mainController;
    @FXML
    ProgressIndicator progessbar;
    boolean updateProgress = false;
    String fileType;
    @FXML
    Hyperlink download;
    @FXML
    Label updateText;
    @FXML
    Button updateButton;
    File downloadedFile;
    String location;

    public void initialize(URL url, ResourceBundle rb) {
        LOG.debug("initialize starts");
        try {
            if (!UpdateUtil.UPDATE_RUNNING) {
                this.startUpdate();
            }
        }
        catch (Exception e) {
            LOG.error("Error in initialize()", e);
        }
    }

    public void openUpdateWindow() {
        this.myDialogStage.show();
    }

    @FXML
    public void cancelUpdate() {
        this.myDialogStage.hide();
    }

    @FXML
    public void download() {
        LOG.info("download starts");
        try {
            File saveFile = mainController.openFileDialog(true, this.fileType, "Save New ITR Version");
            if (saveFile != null) {
                if (!saveFile.getAbsolutePath().toLowerCase().endsWith(this.fileType)) {
                    saveFile = new File(saveFile.getAbsolutePath() + this.fileType);
                }
                FileInputStream fis = new FileInputStream(this.downloadedFile);
                FileOutputStream fos = new FileOutputStream(saveFile);
                int read = 0;
                while ((read = fis.read()) != -1) {
                    fos.write(read);
                }
                fos.close();
                fis.close();
                this.myDialogStage.hide();
                mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("file.download.saved.successfully"), false);
            }
        }
        catch (Exception e) {
            LOG.error("error in downoad ", e);
            mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("error.reading.downloaded.file"), true);
        }
        LOG.info("download ends");
    }

    public void startUpdate() {
        LOG.info("startUpdate starts");
        this.updateProgress = true;
        UpdateUtil updateUtil = new UpdateUtil();
        UpdateUtil.setMainController(mainController);
        updateUtil.setItr(MainController.itrName);
        updateUtil.setAsstYear(MainController.asstYear);
        updateUtil.setVersion(MainController.version);
        updateUtil.setHash(CommonUtil.getHash());
        UpdateUtil.setUpdateController(this);
        Thread thread = new Thread((Runnable)((Object)updateUtil));
        thread.start();
        LOG.info("startUpdate ends");
    }

    @FXML
    public void update() {
        LOG.info("update() starts ");
        this.myDialogStage.hide();
        LOG.info("update thread stats with updateLst:  ");
    }

    public Stage getMyDialogStage() {
        return this.myDialogStage;
    }

    public void setMyDialogStage(Stage myDialogStage) {
        this.myDialogStage = myDialogStage;
    }

    public MainController getMainController() {
        return mainController;
    }

    public static void setMainController(MainController mainController1) {
        mainController = mainController1;
    }

    public Label getUpdateText() {
        return this.updateText;
    }

    public void setUpdateText(Label updateText) {
        this.updateText = updateText;
    }

    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public void setDownloadedFile(File downloadedFile) {
        this.downloadedFile = downloadedFile;
    }

    public Hyperlink getDownload() {
        return this.download;
    }

    public void setDownload(Hyperlink download) {
        this.download = download;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

