/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.FormNameSpaceContext;
import com.tcs.efiling.form.validation.main.FieldRoot;
import com.tcs.efiling.form.validation.main.FieldValidatorRoot;
import com.tcs.efiling.form.validation.main.ParamRoot;
import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidatorInteface;
import com.tcs.efiling.form.validation.main.ValidatorRoot;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidationCacher {
    static final Logger LOG = Logger.getLogger(ValidationCacher.class);
    public static Map<String, ValidatorInteface> VALIDATORS = new HashMap<String, ValidatorInteface>();
    public static Properties VALIDATORS_NAME_VAL;
    public static Properties XPATH_ITR;
    public static Properties APP_PROP;
    public static Properties ON_SUBMIT_VALIDATION_PRPERTIES;
    public static XPath xpath;
    public static Document document;
    public static Map<Class, Map<String, PropertyDescriptor>> PROPERTY_DESCRIPTOR_CACHE;
    public static ValidatorRoot validatorRoot;
    public static Map<String, String> DELETE_ZERO_NODES;
    public static Map<String, List<FieldValidatorRoot>> VALIDATION_MAP;
    public static Map<String, String> XPATH_TO_FIELD;
    static Properties properties;

    public static void setNodeName(Node node, String xpath) {
        String fieldName;
        if (node.getNodeType() != 3) {
            NodeList nodeList = node.getChildNodes();
            int nodeCount = nodeList.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node nodeTemp = nodeList.item(i);
                if (nodeTemp.getNodeType() != 3) {
                    ValidationCacher.setNodeName(nodeTemp, xpath + "/" + nodeTemp.getNodeName());
                }
                nodeCount = nodeList.getLength();
            }
        }
        if ((fieldName = properties.getProperty(xpath.replaceAll(":", "."))) != null && node.getNodeType() == 1) {
            Element element = (Element)node;
            element.setAttribute("name", fieldName);
        }
        LOG.debug("node name: " + node.getNodeName() + " " + xpath + " ");
    }

    public static void load() {
        try {
            VALIDATORS_NAME_VAL = new Properties();
            VALIDATORS_NAME_VAL.load(ValidatorInteface.class.getResourceAsStream("validator.properties"));
            Set<Object> keys = VALIDATORS_NAME_VAL.keySet();
            for (Object obj : keys) {
                String key = (String)obj;
                ValidatorInteface validator = ValidationCacher.getValidator(key);
                VALIDATORS.put(key, validator);
                Class<?> classType = validator.getClass();
                BeanInfo beanInfo = Introspector.getBeanInfo(classType);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                Map<String, PropertyDescriptor> result = PROPERTY_DESCRIPTOR_CACHE.get(classType);
                if (result == null) {
                    result = new HashMap<String, PropertyDescriptor>();
                }
                for (PropertyDescriptor descriptor : propertyDescriptors) {
                    result.put(descriptor.getName().toUpperCase(), descriptor);
                }
                PROPERTY_DESCRIPTOR_CACHE.put(classType, result);
            }
        }
        catch (Exception e) {
            LOG.error("Error in load()", e);
        }
    }

    public static void unmarshalValidationXml() throws Exception {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ValidatorRoot.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            validatorRoot = (ValidatorRoot)unmarshaller.unmarshal((Node)document);
            validatorRoot = (ValidatorRoot)unmarshaller.unmarshal((Node)document);
            for (FieldRoot root : validatorRoot.getFieldRoots()) {
                String name = root.getName();
                List<FieldValidatorRoot> validators = root.getFieldValidatorRoot();
                for (FieldValidatorRoot fieldValidator : validators) {
                    List<ParamRoot> params = fieldValidator.getParams();
                    if (params == null) continue;
                    for (ParamRoot param : params) {
                        try {
                            ValidationCacher.invokeMethod(fieldValidator.getValidator(), param.getName(), param.getValue() == null ? param.getValue() : param.getValue().trim());
                        }
                        catch (Exception e) {
                            LOG.error("iniatialization error in param name:" + param.getName() + " param.value :" + param.getValue());
                            LOG.error("Error is:", e);
                        }
                    }
                }
                VALIDATION_MAP.put(name, root.getFieldValidatorRoot());
            }
        }
        catch (Exception e) {
            LOG.error("unmarshalValidationXml error,", e);
        }
    }

    public static void loadDoc(String itrName, String asstYear, String ver) {
        try {
            xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new FormNameSpaceContext());
            XPATH_ITR = new Properties();
            InputStream fis = FormConfigUtil.getXpathFile(itrName, asstYear, ver);
            XPATH_ITR.load(fis);
            APP_PROP = new Properties();
            InputStream fisProp = FormConfigUtil.getApplicationPropertiesPath(itrName, asstYear, ver);
            APP_PROP.load(fisProp);
            document = FormCacher.getDocument(FormConfigUtil.getValidationFile(itrName, asstYear, ver));
            ValidationCacher.unmarshalValidationXml();
            ValidationCacher.deleteZeroNodeProp(itrName, asstYear, ver);
            ValidationCacher.loadXpathToField(itrName, asstYear, ver);
            FormConfigUtil.loadDeleteNodeGenerateXml(itrName, asstYear, ver);
            fis.close();
            fisProp.close();
        }
        catch (Exception e) {
            LOG.error("Error in loadDoc()", e);
        }
    }

    public static void deleteZeroNodeProp(String itrName, String asstYear, String ver) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(FormConfigUtil.getDeleteZeroNodes(itrName, asstYear, ver)));
        String line = br.readLine();
        while (line != null) {
            String[] str = line.split("=");
            DELETE_ZERO_NODES.put(str[0].trim(), str[1].trim());
            line = br.readLine();
        }
        br.close();
    }

    public static void loadXpathToField(String itrName, String asstYear, String ver) throws Exception {
        Properties properties = new Properties();
        InputStream fis = FormConfigUtil.getXPathToFieldProperties(itrName, asstYear, ver);
        properties.load(fis);
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyS = key.toString();
            XPATH_TO_FIELD.put(keyS, properties.getProperty(keyS));
        }
        fis.close();
    }

    public static void loadTableValidator(String itrName, String asstYear, String ver) throws Exception {
        String xpathStr = "//field-validator[@type='validateTable']";
        NodeList nodeList = (NodeList)xpath.evaluate(xpathStr, document, XPathConstants.NODESET);
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = nodeList.item(i);
            String fieldName = node.getParentNode().getAttributes().getNamedItem("name").getNodeValue();
            String visitorClassPath = ValidationCacher.getParamVal(fieldName, "visitorClassPath", "validateTable", node);
            String context = ValidationCacher.getParamVal(fieldName, "context", "validateTable", node);
            if (visitorClassPath.indexOf(".") != -1) {
                visitorClassPath = visitorClassPath.substring(visitorClassPath.lastIndexOf(".") + 1);
            }
            context = visitorClassPath + "-" + context + "-validation.xml";
            String validationFile = FormConfigUtil.getValidationFile(itrName, asstYear, ver, context);
            Document tableDoc = FormCacher.getDocument(validationFile);
            NodeList nodeList2 = (NodeList)xpath.evaluate("//field", tableDoc, XPathConstants.NODESET);
            int count2 = nodeList2.getLength();
            for (int j = 0; j < count2; ++j) {
                Node node2 = nodeList2.item(j);
                Node temp2 = node2.getAttributes().getNamedItem("name");
                temp2.setNodeValue(fieldName + "[0]." + temp2.getNodeValue());
                Node tempN = document.importNode(node2, true);
                document.getFirstChild().appendChild(tempN);
            }
        }
    }

    public static String getParamVal(String name, String param, String type, Node node) throws ValidationException {
        String val = null;
        try {
            if (name.contains("[") && name.contains("]")) {
                name = name.replaceAll("\\[[0-9]*\\]", "[0]");
            }
            String prefix = "//field[@name='" + name + "']//field-validator[@type='" + type + "']";
            val = ValidationCacher.getNodeValue(prefix + "//param[@name='" + param + "']", node);
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public static String getNodeValue(String xpathStr, Node doc) throws ValidationException {
        String val = null;
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(xpathStr, doc, XPathConstants.NODESET);
            if (nodeList != null && nodeList.getLength() != 0) {
                val = nodeList.item(0).getTextContent();
            }
        }
        catch (Exception e) {
            LOG.error("Error in getNodeValue()", e);
            throw new ValidationException(e);
        }
        return val;
    }

    public static String getError(String key) {
        String val = APP_PROP.getProperty(key);
        if (val != null) {
            val = val.replaceAll("\"", "'");
        }
        return val == null ? key : val;
    }

    public static String getMandatoryFieldNames(String name, Node node) throws Exception {
        return ValidationCacher.getParamVal(name, "validateTable", "mandatoryFieldNames", node);
    }

    public static ValidatorInteface getValidator(String key) throws Exception {
        return (ValidatorInteface)Class.forName(VALIDATORS_NAME_VAL.getProperty(key)).newInstance();
    }

    public static String getXPath(String key) {
        return XPATH_ITR.getProperty(key);
    }

    public static void invokeMethod(ValidatorInteface validator, String name, String value) {
        try {
            PropertyDescriptor descriptor = PROPERTY_DESCRIPTOR_CACHE.get(validator.getClass()).get(name.toUpperCase());
            Method method = descriptor.getWriteMethod();
            String className = descriptor.getPropertyType().getName();
            if (className.contains("BigDecimal")) {
                method.invoke((Object)validator, new BigDecimal(value));
            } else if (className.contains("BigInteger")) {
                method.invoke((Object)validator, new BigInteger(value));
            } else if (className.contains("Boolean")) {
                method.invoke((Object)validator, Boolean.valueOf(value));
            } else if (className.contains("Integer") || className.contains("int")) {
                method.invoke((Object)validator, Integer.parseInt(value));
            } else if (className.contains("Long") || className.contains("long")) {
                method.invoke((Object)validator, Long.parseLong(value));
            } else if (className.contains("Double") || className.contains("double")) {
                method.invoke((Object)validator, Double.parseDouble(value));
            } else if (className.contains("Float") || className.contains("float")) {
                method.invoke((Object)validator, Float.valueOf(Float.parseFloat(value)));
            } else {
                method.invoke((Object)validator, value);
            }
        }
        catch (Exception e) {
            LOG.error("Error in invokeMethod()", e);
            LOG.error("no invoke method for name: " + name + "  " + validator + "  ");
        }
    }

    static {
        PROPERTY_DESCRIPTOR_CACHE = new HashMap<Class, Map<String, PropertyDescriptor>>();
        DELETE_ZERO_NODES = new LinkedHashMap<String, String>();
        VALIDATION_MAP = new HashMap<String, List<FieldValidatorRoot>>();
        XPATH_TO_FIELD = new HashMap<String, String>();
    }
}

