/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.FormUploadRequest;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.config.SchemaCheck;
import com.tcs.efiling.form.config.UsbTokenModel;
import com.tcs.efiling.form.config.UsbTokenUtil;
import com.tcs.efiling.form.main.CreateHash;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.FormNameSpaceContext;
import com.tcs.efiling.form.main.FormUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.SignerUtil;
import com.tcs.efiling.form.main.ValidationCacher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.web.WebEngine;
import javafx.stage.FileChooser;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebServiceUtilBulk
extends Task<Void> {
    static final Logger LOG = Logger.getLogger(ValidationCacher.class);
    static SOAPConnectionFactory soapConnectionFactory;
    static SOAPConnection soapConnection;
    static String url;
    static String xml;
    static MainController mainController;
    static WebEngine webServiceEngine;
    int process = 0;
    static List<File> formFile;
    static File pfxFile;
    static File itrvSaveFile;
    String faultString;
    String ackNo;
    String transactionId;
    String emailId;
    boolean isUnderProcess = false;
    static FormUploadRequest request;
    public static final Map<String, SchemaCheck> FILE_MAP;
    static JAXBContext context;
    public static Map<String, File> ALL_ATTACHMENTS;
    SOAPMessage soapMessage;
    String msg;
    static String exception;
    static List<String> schemaError;
    public static XPath xpath;
    static DocumentBuilderFactory dbf;
    private SignerUtil signerUtil;
    boolean usbTokenLoaded = false;
    Map<String, UsbTokenModel> tokens;
    File initDirectory;

    public static void init() {
        try {
            if (soapConnectionFactory == null) {
                soapConnectionFactory = SOAPConnectionFactory.newInstance();
                soapConnection = soapConnectionFactory.createConnection();
                url = FormConfigUtil.getConfigProperty("webservice.url");
                context = JAXBContext.newInstance((Class[])new Class[]{FormUploadRequest.class});
                LOG.info("webservie url: " + url);
            }
        }
        catch (Exception e) {
            LOG.error("Error in init", e);
        }
    }

    public SOAPMessage sendSoapMessage(File formFile) throws Exception {
        LOG.info("sendSoapMessage starts for file: " + formFile.getAbsolutePath());
        SecureRandom secureRandom = new SecureRandom();
        int random = secureRandom.nextInt();
        String zipFileName = "FormUpload" + random;
        File tempFile = File.createTempFile(zipFileName, ".zip");
        FileInputStream fis = new FileInputStream(formFile);
        FileOutputStream fos = new FileOutputStream(tempFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        ZipEntry zipEntry = new ZipEntry(formFile.getName());
        zos.putNextEntry(zipEntry);
        int read = 0;
        while ((read = fis.read()) != -1) {
            zos.write(read);
        }
        zos.closeEntry();
        fis.close();
        zos.close();
        fos.close();
        LOG.info("createing temp zip file to send: " + tempFile.getAbsolutePath());
        if (this.signerUtil != null) {
            String signature = this.signerUtil.initSignature(new FileInputStream(tempFile));
            request.setSignature(signature);
        }
        MessageFactory messageFactory = MessageFactory.newInstance();
        this.soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = this.soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody soapBody = envelope.getBody();
        Marshaller marshaller = context.createMarshaller();
        request.setVersion(mainController.getVersion());
        request.setJarHash(CreateHash.generateHashSubmit());
        marshaller.marshal((Object)request, (Node)soapBody);
        DataHandler dh = new DataHandler((DataSource)new FileDataSource(tempFile));
        AttachmentPart attachment = this.soapMessage.createAttachmentPart(dh);
        this.soapMessage.addAttachmentPart(attachment);
        if (!ALL_ATTACHMENTS.isEmpty()) {
            LOG.info("ALL_ATTACHMENTS: " + ALL_ATTACHMENTS);
            for (String key : ALL_ATTACHMENTS.keySet()) {
                File tempAttach = ALL_ATTACHMENTS.get(key);
                dh = new DataHandler((DataSource)new FileDataSource(tempAttach));
                attachment = this.soapMessage.createAttachmentPart(dh);
                this.soapMessage.addAttachmentPart(attachment);
            }
        }
        LOG.info("before calling  url: ={}" + url);
        SOAPMessage response = soapConnection.call(this.soapMessage, (Object)url);
        LOG.info("sendSoapMessage ends with response: " + response);
        return response;
    }

    public void sendRequest(final String index, final File formFile) {
        block7: {
            LOG.info("sendRequest starts");
            if (FormUtil.isConnected()) {
                try {
                    schemaError.clear();
                    SOAPMessage response = this.sendSoapMessage(formFile);
                    SOAPBody resBody = response.getSOAPPart().getEnvelope().getBody();
                    SOAPFault soapFault = resBody.getFault();
                    LOG.info("Soap fault: " + soapFault);
                    if (soapFault != null) {
                        this.faultString = soapFault.getFaultString();
                        if (this.faultString != null && this.faultString.indexOf("error.") != -1) {
                            this.faultString = FormConfigUtil.getConfigProperty(this.faultString);
                        }
                        final String error = this.faultString.replaceAll("'", "\"");
                        schemaError.add(error);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                webServiceEngine.executeScript("showFault('" + index + "','" + error + "','" + formFile.getName() + "');");
                            }
                        });
                        break block7;
                    }
                    this.transactionId = resBody.getElementsByTagName("Result").item(0).getTextContent();
                    this.ackNo = resBody.getElementsByTagName("AckNo").item(0).getTextContent();
                    LOG.info("transactionId:" + this.transactionId + ",ackNo:" + this.ackNo);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            webServiceEngine.executeScript("showResults('" + index + "','" + WebServiceUtilBulk.this.transactionId + "','" + WebServiceUtilBulk.this.ackNo + "');");
                        }
                    });
                }
                catch (Exception e) {
                    LOG.error("Error in sendRequest: ", e);
                    exception = e.getMessage().replace("'", "\"");
                    if (exception.indexOf("404Not Found") != -1) {
                        exception = FormConfigUtil.getConfigProperty("error.connecting.to.server");
                    }
                    schemaError.add(exception);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            webServiceEngine.executeScript("showFault('" + index + "','" + exception + "','" + formFile.getName() + "');");
                        }
                    });
                }
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        webServiceEngine.executeScript("showFault('" + index + "','" + FormConfigUtil.getConfigProperty("form.net.error") + "','" + formFile.getName() + "');");
                    }
                });
            }
        }
    }

    public void startValidationTask() {
        LOG.info("startValidationTask starts");
        webServiceEngine.executeScript("toggleSubmit(true);");
        webServiceEngine.executeScript("toggleValidate(true);");
        webServiceEngine.executeScript("document.getElementById('note').style.display='block';");
        WebServiceUtilBulk util = new WebServiceUtilBulk();
        util.isUnderProcess = true;
        util.process = 0;
        util.setMainController(mainController);
        Thread utilThread = new Thread((Runnable)((Object)util));
        utilThread.start();
        LOG.info("startValidationTask ends after starting thread: ={}" + utilThread);
    }

    public void validateXml() throws Exception {
        LOG.info("validateXml starts for filematp." + FILE_MAP);
        long time1 = System.currentTimeMillis();
        try {
            if (xpath == null) {
                xpath = XPathFactory.newInstance().newXPath();
                xpath.setNamespaceContext(new FormNameSpaceContext());
            }
            for (String index : FILE_MAP.keySet()) {
                schemaError = new ArrayList<String>();
                SchemaCheck sc = FILE_MAP.get(index);
                File fileProcess = sc.getFormFile();
                Document document = FormCacher.getDocument(fileProcess);
                String formName = (String)xpath.evaluate("//Form:Form_Details/Form:FormName", document, XPathConstants.STRING);
                String asstYear = (String)xpath.evaluate("//Form:Form_Details/Form:AssessmentYear", document, XPathConstants.STRING);
                String xmlSchemaVer = (String)xpath.evaluate("//Form:Form_Details/Form:SchemaVer", document, XPathConstants.STRING);
                String panProp = FormConfigUtil.getConfigProperty("form." + formName + ".pan");
                String nameProp = FormConfigUtil.getConfigProperty("form." + formName + ".name");
                String pan = (String)xpath.evaluate(panProp, document, XPathConstants.STRING);
                String name = (String)xpath.evaluate(nameProp, document, XPathConstants.STRING);
                sc.setPan(pan);
                sc.setName(name);
                LOG.info("validateXml for file: " + fileProcess.getAbsolutePath() + " formName: " + formName);
                LOG.info("asstYear: " + asstYear + " panProp: " + panProp + ",pan: " + pan + ",nameProp: " + nameProp + ",name: " + name);
                if ("FORM15CA".equals(formName)) {
                    asstYear = "Current A.Y";
                    request.setNonAuditFlag("Y");
                } else {
                    request.setNonAuditFlag("N");
                }
                request.setFormName(formName);
                if (!MainController.itrName.equals(formName)) {
                    schemaError.add(FormConfigUtil.getConfigProperty("form.or.asstYear.invalid"));
                } else {
                    String ver = FormConfigUtil.getVersion(formName, asstYear);
                    String saveDraft = document.getDocumentElement().getAttribute("savedraft");
                    LOG.info("saveDraft : " + saveDraft);
                    if (saveDraft != null && saveDraft.equalsIgnoreCase("yes")) {
                        schemaError.add(FormConfigUtil.getConfigProperty("form.xml.save.draft"));
                    } else if ("FORM15CA".equals(formName) && FormConfigUtil.getFormVersion("form15ca.schema.min").compareTo(xmlSchemaVer) > 0) {
                        schemaError.add(FormConfigUtil.getConfigProperty("form.schema.version.not.supported"));
                    } else {
                        schemaError = FormCacher.schemeValidate(fileProcess.getAbsolutePath(), formName, asstYear, ver);
                    }
                }
                sc.setSchemaError(schemaError);
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (String index : FILE_MAP.keySet()) {
                        SchemaCheck sc = FILE_MAP.get(index);
                        String pan = sc.getPan();
                        String name = sc.getName();
                        List<String> schemaError = sc.getSchemaError();
                        File fileProcess = sc.getFormFile();
                        if (pan != null && pan.trim().length() != 0) {
                            webServiceEngine.executeScript("setPanAndName('" + index + "','" + pan + "','" + name + "');");
                        }
                        if (name != null && name.length() != 0) {
                            webServiceEngine.executeScript("setPanAndName('" + index + "','" + pan + "','" + name + "');");
                        }
                        for (String error : schemaError) {
                            error = error.replaceAll("'", "\"");
                            LOG.info("set schema error for index: " + index + " error: " + error);
                            webServiceEngine.executeScript("setSchemaErrors('" + index + "','" + error + "','" + fileProcess.getName() + "');");
                        }
                        if (schemaError != null && !schemaError.isEmpty()) continue;
                        webServiceEngine.executeScript("setNoSchemaErrors('" + index + "');");
                    }
                    webServiceEngine.executeScript("document.getElementsByName('validate')[0].removeAttribute('disabled');");
                }
            });
        }
        catch (Exception e) {
            LOG.error("error in validate xml: ", e);
        }
        long time2 = System.currentTimeMillis();
        LOG.info("validateXml ends with schema error size: " + schemaError.size() + ": time taken: " + (time2 - time1));
    }

    public static String getCurrentDate() {
        StringBuffer currentDate = new StringBuffer();
        GregorianCalendar calendar = new GregorianCalendar();
        int currentDay = calendar.get(5);
        int currentMonth = calendar.get(2) + 1;
        int currentYear = calendar.get(1);
        currentDate.append(Integer.toString(currentYear));
        currentDate.append('-');
        if (currentMonth <= 9) {
            currentDate.append('0');
        }
        currentDate.append(Integer.toString(currentMonth));
        currentDate.append('-');
        if (currentDay <= 9) {
            currentDate.append('0');
        }
        currentDate.append(Integer.toString(currentDay));
        return currentDate.toString();
    }

    public Object getSchemaErrors() {
        if (schemaError.isEmpty()) {
            return FormConfigUtil.getConfigProperty("no.schema.error");
        }
        return schemaError;
    }

    public void addMoreFiles() {
        try {
            LOG.info("addMoreFiles starts webServiceEngine:" + webServiceEngine);
            this.openFileDialog();
            if (formFile != null) {
                webServiceEngine.executeScript("toggleSubmit(true);");
                String obj = (String)webServiceEngine.executeScript("getFileSN()");
                int totalFileCount = Integer.parseInt(obj);
                LOG.info("addMoreFiles SN " + obj);
                for (int i = 0; i < formFile.size(); ++i) {
                    File file = formFile.get(i);
                    int tempCount = totalFileCount + i + 1;
                    boolean reapeat = false;
                    for (String mapFile : FILE_MAP.keySet()) {
                        if (!FILE_MAP.get(mapFile).getFormFile().getAbsolutePath().equals(file.getAbsolutePath())) continue;
                        reapeat = true;
                        break;
                    }
                    if (reapeat) continue;
                    SchemaCheck sc = new SchemaCheck();
                    sc.setFormFile(file);
                    FILE_MAP.put(Integer.toString(tempCount), sc);
                    String filePath = file.getName();
                    webServiceEngine.executeScript("setFormFile('" + tempCount + "','" + filePath + "')");
                }
            }
        }
        catch (Exception e) {
            LOG.error("browse error", e);
        }
    }

    public void browse() {
        try {
            FILE_MAP.clear();
            LOG.info("Browse starts webServiceEngine:" + webServiceEngine);
            this.openFileDialog();
            if (formFile != null) {
                for (int i = 0; i < formFile.size(); ++i) {
                    File file = formFile.get(i);
                    int tempCount = i + 1;
                    SchemaCheck sc = new SchemaCheck();
                    sc.setFormFile(file);
                    FILE_MAP.put(Integer.toString(tempCount), sc);
                    String filePath = file.getName();
                    webServiceEngine.executeScript("setFormFile('" + tempCount + "','" + filePath + "')");
                }
                webServiceEngine.executeScript("document.getElementById('showXmls').style.display='block';");
                if (FILE_MAP.size() > 0) {
                    webServiceEngine.executeScript("document.getElementById('browseFile').disabled=true;");
                    webServiceEngine.executeScript("document.getElementById('addMoreFiles').removeAttribute('disabled');");
                    webServiceEngine.executeScript("document.getElementById('deleteFiles').removeAttribute('disabled');");
                }
            }
        }
        catch (Exception e) {
            LOG.error("browse error", e);
        }
    }

    public void delete() {
        LOG.info("delete starts");
        FILE_MAP.clear();
        webServiceEngine.executeScript("clearFiles()");
        LOG.info("delete ends");
    }

    public void deleteFiles() {
        LOG.info("delete starts");
        JSObject jsObject = (JSObject)webServiceEngine.executeScript("clearCheckedFiles()");
        int rowLength = (Integer)jsObject.getMember("length");
        for (int i = 0; i < rowLength; ++i) {
            String objj = (String)jsObject.getSlot(i);
            FILE_MAP.remove(objj);
        }
        if (FILE_MAP.size() == 0) {
            webServiceEngine.executeScript("document.getElementById('showXmls').style.display='none'");
            webServiceEngine.executeScript("document.getElementById('browseFile').removeAttribute('disabled');");
            webServiceEngine.executeScript("document.getElementById('addMoreFiles').disabled=true;");
            webServiceEngine.executeScript("document.getElementById('deleteFiles').disabled=true;");
            webServiceEngine.executeScript("document.getElementById('all').checked=false;");
            webServiceEngine.executeScript("document.getElementById('note').style.display='none';");
        }
    }

    protected Void call() throws Exception {
        long time1 = System.currentTimeMillis();
        try {
            if (this.process == 1) {
                WebServiceUtilBulk.init();
                LOG.info("Thread call starts FILE_MAP size: =" + FILE_MAP.size());
                this.isUnderProcess = true;
                for (String index : FILE_MAP.keySet()) {
                    File file = FILE_MAP.get(index).getFormFile();
                    if (this.signerUtil != null) {
                        // empty if block
                    }
                    this.sendRequest(index, file);
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("form.submitted"), false);
                    }
                });
            } else if (this.process == 0) {
                this.validateXml();
            }
        }
        catch (Exception e) {
            LOG.error("Error in call function", e);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    mainController.generateErrorDialog("Error at cliet side: " + e.getMessage(), true);
                }
            });
        }
        long time2 = System.currentTimeMillis();
        LOG.info("Thread call ends : time taken: " + (time2 - time1));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                webServiceEngine.executeScript("toggleSubmit(false);");
                webServiceEngine.executeScript("toggleValidate(false);");
            }
        });
        return null;
    }

    public void validateDSC() throws Exception {
        String dscFlag = request.getDscFlag();
        if (dscFlag.equals("Y")) {
            String keyPass = (String)webServiceEngine.executeScript("document.getElementsByName('keystoreKey')[0].value");
            boolean usbTokenStatus = (Boolean)webServiceEngine.executeScript("document.getElementsByName('typeOfDsc')[0].checked");
            if (usbTokenStatus) {
                this.signerUtil = new SignerUtil();
                this.signerUtil.intCertChain(new FileInputStream(pfxFile), keyPass);
                this.setCertChain(this.signerUtil.getCertChain());
                LOG.info("certChain: " + this.signerUtil.getCertChain());
            } else {
                this.signerUtil = new SignerUtil();
                String aliasKey = (String)webServiceEngine.executeScript("getTokenAlial()");
                String alias = (String)this.tokens.keySet().toArray()[Integer.parseInt(aliasKey)];
                UsbTokenModel usbTokenModel = this.tokens.get(alias);
                LOG.info("usbTokenModel :- " + usbTokenModel);
                this.signerUtil.intCertChainUsbToken(UsbTokenUtil.keyStore, alias);
                this.setCertChain(this.signerUtil.getCertChain());
            }
        }
    }

    public boolean validateDSCHtml() {
        boolean flag = false;
        try {
            this.validateDSC();
            flag = true;
        }
        catch (Exception e) {
            LOG.error("validateDSCHtml,", e);
        }
        return flag;
    }

    public void checkUsbToken() {
        LOG.info("checkUsbToken starts");
        if (this.usbTokenLoaded) {
            return;
        }
        this.usbTokenLoaded = true;
        try {
            this.tokens = UsbTokenUtil.getUsbTokenData();
            for (String key : this.tokens.keySet()) {
                UsbTokenModel token = this.tokens.get(key);
                System.out.println("token :- " + token.toString());
                System.out.println("key :- " + key);
                webServiceEngine.executeScript("setUsbToken('" + key + "','" + token.getIssuedBy() + "','" + token.getIssuedTo() + "','" + token.getValidForm() + "','" + token.getValidTill() + "')");
            }
        }
        catch (Exception e) {
            LOG.error("checkUsbToken", e);
        }
    }

    public void startWebseviceTask() {
        LOG.info("startWebseviceTask starts");
        webServiceEngine.executeScript("toggleSubmit(true);");
        webServiceEngine.executeScript("toggleValidate(true);");
        try {
            this.validateDSC();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("javax.crypto.BadPaddingException") != -1) {
                mainController.generateErrorDialog(FormConfigUtil.getConfigProperty("invalid.dsc.password"), true);
            } else {
                mainController.generateErrorDialog(e.getMessage(), true);
            }
            LOG.error("startWebseviceTask", e);
            webServiceEngine.executeScript("toggleSubmit(false);");
            return;
        }
        WebServiceUtilBulk util = new WebServiceUtilBulk();
        util.isUnderProcess = true;
        util.process = 1;
        util.setMainController(mainController);
        util.signerUtil = this.signerUtil;
        Thread utilThread = new Thread((Runnable)((Object)util));
        utilThread.start();
        LOG.info("startWebseviceTask ends after starting thread: ={}" + utilThread);
    }

    public void keyStoreFile() {
        pfxFile = mainController.openFileDialog(false, ".pfx,.p12", null);
        if (pfxFile != null) {
            webServiceEngine.executeScript("document.getElementById('pfxVal').innerHTML='" + pfxFile.getName() + "';");
        } else {
            webServiceEngine.executeScript("document.getElementById('pfxVal').innerHTML='';");
        }
    }

    public static void hexWriteToFile(String hexStr, String fileToWrite) throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(fileToWrite));
        fos.write(WebServiceUtilBulk.decode(hexStr.getBytes()));
        fos.close();
    }

    public static byte[] decode(byte[] data) {
        int j = 0;
        byte[] result = new byte[data.length / 2];
        int i = 0;
        while (i < data.length) {
            byte b;
            byte c = data[i++];
            byte d = data[i++];
            if (c >= 48 && c <= 57) {
                b = (byte)(c - 48 << 4);
            } else if (c >= 65 && c <= 70) {
                b = (byte)(c - 65 + 10 << 4);
            } else if (c >= 97 && c <= 102) {
                b = (byte)(c - 97 + 10 << 4);
            } else {
                throw new IllegalArgumentException("Invalid hex digit: " + c);
            }
            if (d >= 48 && d <= 57) {
                b = (byte)(b + (byte)(d - 48));
            } else if (d >= 65 && d <= 70) {
                b = (byte)(b + (byte)(d - 65 + 10));
            } else if (d >= 97 && d <= 102) {
                b = (byte)(b + (byte)(d - 97 + 10));
            } else {
                throw new IllegalArgumentException("Invalid hex digit: " + d);
            }
            result[j++] = b;
        }
        return result;
    }

    public MainController getMainController() {
        return mainController;
    }

    public void setMainController(MainController mainController) {
        WebServiceUtilBulk.mainController = mainController;
    }

    public WebEngine getWebServiceEngine() {
        return webServiceEngine;
    }

    public void setWebServiceEngine(WebEngine webServiceEngine) {
        WebServiceUtilBulk.webServiceEngine = webServiceEngine;
    }

    public void selectAllFiles() {
        LOG.info("Inside selectAllFiles");
        webServiceEngine.executeScript("selectAllFiles()");
    }

    public void openFileDialog() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = null;
        extFilter = new FileChooser.ExtensionFilter("ZIP file (.xml)", new String[]{"*.xml"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        fileChooser.setInitialDirectory(this.initDirectory);
        fileChooser.setTitle("Open Form(XML) File.");
        formFile = fileChooser.showOpenMultipleDialog(null);
        if (formFile != null && !formFile.isEmpty() && formFile.get(0).getParentFile().isDirectory()) {
            this.initDirectory = formFile.get(0).getParentFile();
        }
    }

    public void setUserId(String userId) {
        request.setUserId(userId);
    }

    public void setDscFlag(String dscFlag) {
        request.setDscFlag(dscFlag);
    }

    public void setCertChain(String certChain) {
        request.setCertChain(certChain);
    }

    public void setFormName(String formName) {
        request.setFormName(formName);
    }

    public void setAsstYear(String asstYear) {
        request.setAsstYear(asstYear);
    }

    public void setNonAuditFlag(String auditFlag) {
        request.setNonAuditFlag(auditFlag);
    }

    public void setPassword(String password) {
        request.setPassword(password);
    }

    public void setDob(String dob) {
        request.setDob(dob);
    }

    static {
        url = "";
        request = new FormUploadRequest();
        FILE_MAP = new LinkedHashMap<String, SchemaCheck>();
        context = null;
        ALL_ATTACHMENTS = new HashMap<String, File>();
        exception = "";
        dbf = DocumentBuilderFactory.newInstance();
    }
}

