/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validators;

import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateTypeValidator
extends ValidatorInteface {
    private String dateFormat;
    private String min;
    private String max;
    private String conAttributeName;
    private String conAttributeValue;

    @Override
    public void validate(String val, String name, Validator validator) throws ValidationException {
        Date fieldDate;
        SimpleDateFormat simpleDateFormat;
        String dateObject = val;
        this.min = this.processDate(this.min);
        this.max = this.processDate(this.max);
        String fieldValue = null;
        if (ValidationUtil.isStringEmpty(this.dateFormat)) {
            this.dateFormat = "dd/MM/yyyy";
        }
        if (dateObject instanceof Date) {
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(this.dateFormat, Locale.US);
            fieldValue = simpleDateFormat2.format(dateObject);
        } else {
            fieldValue = dateObject;
        }
        String acctualConAttribute = validator.getFormValue(this.conAttributeName, name);
        if (!ValidationUtil.isDateValid(fieldValue, this.dateFormat)) {
            this.addFieldError(name, validator);
        }
        if (acctualConAttribute != null) {
            simpleDateFormat = new SimpleDateFormat(this.dateFormat, Locale.US);
            try {
                fieldDate = simpleDateFormat.parse(fieldValue);
                if (!ValidationUtil.isDateValid(fieldValue, this.dateFormat)) {
                    this.addFieldError(name, validator);
                }
                if (!(ValidationUtil.isStringEmpty(this.min) || ValidationUtil.isDateValid(fieldValue, this.dateFormat) && fieldDate.compareTo(simpleDateFormat.parse(this.min)) >= 0)) {
                    this.addFieldError(name, validator);
                }
                if (!(ValidationUtil.isStringEmpty(this.max) || ValidationUtil.isDateValid(fieldValue, this.dateFormat) && fieldDate.compareTo(simpleDateFormat.parse(this.max)) <= 0)) {
                    this.addFieldError(name, validator);
                }
            }
            catch (ParseException e) {
                this.addFieldError(name, validator);
            }
        }
        if (this.conAttributeName == null) {
            simpleDateFormat = new SimpleDateFormat(this.dateFormat, Locale.US);
            if (fieldValue != null && !fieldValue.equals("")) {
                try {
                    fieldDate = simpleDateFormat.parse(fieldValue);
                    if (!ValidationUtil.isDateValid(fieldValue, this.dateFormat)) {
                        this.addFieldError(name, validator);
                    }
                    if (!ValidationUtil.isStringEmpty(this.min)) {
                        if ("currentDate".equals(this.min)) {
                            this.min = simpleDateFormat.format(new Date());
                        }
                        if (!ValidationUtil.isDateValid(fieldValue, this.dateFormat) || fieldDate.compareTo(simpleDateFormat.parse(this.min)) < 0) {
                            this.addFieldError(name, validator);
                        }
                    }
                    if (!ValidationUtil.isStringEmpty(this.max)) {
                        if ("currentDate".equals(this.max)) {
                            this.max = simpleDateFormat.format(new Date());
                        }
                        if (!ValidationUtil.isDateValid(fieldValue, this.dateFormat) || fieldDate.compareTo(simpleDateFormat.parse(this.max)) > 0) {
                            this.addFieldError(name, validator);
                        }
                    }
                }
                catch (ParseException e) {
                    this.addFieldError(name, validator);
                }
            }
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getConAttributeName() {
        return this.conAttributeName;
    }

    public void setConAttributeName(String conAttributeName) {
        this.conAttributeName = conAttributeName;
    }

    public String getConAttributeValue() {
        return this.conAttributeValue;
    }

    public void setConAttributeValue(String conAttributeValue) {
        this.conAttributeValue = conAttributeValue;
    }

    private String processDate(String date) {
        if (ValidationUtil.isStringEmpty(date)) {
            return date;
        }
        if (date.equals("prevAYStart")) {
            date = this.getPrevAYStartDate();
        } else if (date.equals("nextAYEnd")) {
            date = this.getNextAYEndDate();
        }
        return date;
    }

    private String getPrevAYStartDate() {
        return "01/04/" + (DateTypeValidator.getCurrentAsstYear() - 1);
    }

    private String getNextAYEndDate() {
        return "31/03/" + (DateTypeValidator.getCurrentAsstYear() + 2);
    }

    public static int getCurrentAsstYear() {
        int year;
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2);
        int asstYear = year = cal.get(1);
        if (month <= 2) {
            asstYear = year - 1;
        }
        return asstYear;
    }
}

