/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.validators;

import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;

public class LongValidator
extends ValidatorInteface {
    private static final Long MIN_AMOUNT = Long.MIN_VALUE;
    private static final Long MAX_AMOUNT = 99999999999999999L;
    private String conAttributeName;
    private String conAttributeValue;
    private Long minValue;
    private Long maxValue;
    private Boolean mandatory;

    @Override
    public void validate(String val, String name, Validator validator) throws ValidationException {
        Long fieldValue = null;
        if (val != null && val.length() != 0) {
            fieldValue = Long.parseLong(val);
        }
        String acctualConAttributeValue = validator.getFormValue(this.conAttributeName, name);
        if (this.mandatory == null) {
            this.mandatory = false;
        }
        Long minValueTemp = MIN_AMOUNT;
        if (this.minValue != null) {
            minValueTemp = this.minValue;
        }
        Long maxValueTemp = MAX_AMOUNT;
        if (this.maxValue != null) {
            maxValueTemp = this.maxValue;
        }
        if (!ValidationUtil.isStringEmpty(acctualConAttributeValue) && acctualConAttributeValue.equals(this.conAttributeValue)) {
            if (fieldValue == null) {
                this.addFieldError(name, validator);
            } else if (fieldValue.compareTo(minValueTemp) < 0 || fieldValue.compareTo(maxValueTemp) > 0) {
                this.addFieldError(name, validator);
            }
        } else if (!(ValidationUtil.isStringEmpty(this.conAttributeName) || fieldValue == null || fieldValue.compareTo(MIN_AMOUNT) >= 0 && fieldValue.compareTo(MAX_AMOUNT) <= 0)) {
            this.addFieldError(name, validator);
        }
    }

    public String getConAttributeName() {
        return this.conAttributeName;
    }

    public void setConAttributeName(String conAttributeName) {
        this.conAttributeName = conAttributeName;
    }

    public String getConAttributeValue() {
        return this.conAttributeValue;
    }

    public void setConAttributeValue(String conAttributeValue) {
        this.conAttributeValue = conAttributeValue;
    }

    public Long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Long minValue) {
        this.minValue = minValue;
    }

    public Long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Long maxValue) {
        this.maxValue = maxValue;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }
}

