/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.plugins.csv;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.FormUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.PreviewUtil;
import com.tcs.efiling.form.main.ValidationCacher;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validators.TableValidator;
import com.tcs.efiling.plugins.Plugin;
import com.tcs.efiling.plugins.csv.CSVPlugin;
import com.tcs.efiling.plugins.csv.CSVTableValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.stage.FileChooser;
import javax.xml.xpath.XPathConstants;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSVPluginOtherTables
implements Plugin {
    private static FileChooser fileChooser;
    public static final String ID = "CSV_PLUGIN_3CB_OTHERS";
    private static Map<String, File> tempImportedFiles;
    private static Map<String, List<String[]>> tableValueMatrix;
    private static Node dummyRoot;
    private static int rowAdded;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void init() {
    }

    @Override
    public Object invoke(String actionType, JSObject args) {
        if ("GET_DATA".equals(actionType)) {
            this.importCSVDataToTable(args, actionType);
        } else {
            if ("PT21BIA_FILL_DATA".equals(actionType)) {
                return this.fillToTable(args, actionType);
            }
            if ("GET_FIELDS".equals(actionType)) {
                return this.getFieldsFromFile(args);
            }
            if ("SAVE_CSV".equals(actionType)) {
                return this.saveFieldsInFile(args);
            }
            if ("VIEW_INSTRUCTIONS".equals(actionType)) {
                return this.displayCSVInstructions(args);
            }
            if ("SAVE_CSV_CUSTOM".equals(actionType)) {
                return this.saveFieldsOtherInFile(args);
            }
            if ("DELETE_ROW".equals(actionType)) {
                return this.deleteCSVFile(args);
            }
            if ("SAVE_CSV_CUSTOM2".equals(actionType)) {
                return this.saveFieldsInFileCustom(args);
            }
        }
        return null;
    }

    private boolean importCSVDataToTable(JSObject args, String actionType) {
        int len = (Integer)args.getMember("length");
        String[] strArgs = new String[len];
        for (int i = 0; i < len; ++i) {
            strArgs[i] = (String)args.getSlot(i);
        }
        this.initFileChooser(".csv");
        File file = fileChooser.showOpenDialog(null);
        if (file == null) {
            return false;
        }
        Map<String, String> hashMap = this.importDataToTable(strArgs[0], strArgs[1], file);
        if (hashMap.get("error") == null) {
            MainController.itrEngine.executeScript("setCSVImportValues('" + strArgs[0] + "'," + hashMap.get("lineNo") + ",'" + hashMap.get("html") + "','importCsv');");
            if (strArgs[0].equals("form5Annex5pt1Table") || strArgs[0].equals("form5Annex5pt2Table") || strArgs[0].equals("form5Annex5pt3aTable") || strArgs[0].equals("form5Annex5pt3bTable") || strArgs[0].equals("form5Annex5pt3cTable") || strArgs[0].equals("form5Annex5pt3dTable") || strArgs[0].equals("form5Annex5pt4Table") || strArgs[0].equals("form5Annex5pt5aTable") || strArgs[0].equals("form5Annex5pt5bTable") || strArgs[0].equals("form5Annex5pt5cTable") || strArgs[0].equals("form5Annex5pt6Table")) {
                MainController.itrEngine.executeScript("setTotalValues('" + strArgs[0] + "','" + hashMap.get("sumVal") + "');");
            }
            return true;
        }
        MainController.itrEngine.executeScript("showErrorMessage(\"" + hashMap.get("error") + "\");");
        return false;
    }

    private Map<String, String> importDataToTable(String tableId, String tablePrefix, File file) {
        int lineNo = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            File tmpFile = File.createTempFile("ITD", tableId);
            BufferedReader br = new BufferedReader(new FileReader(file));
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
            StringBuilder html = new StringBuilder();
            String error = null;
            CSVTableValidator csvTableValidator = new CSVTableValidator(tableId, tablePrefix);
            TableValidator tableValidator = (TableValidator)ValidationCacher.VALIDATION_MAP.get(tablePrefix).get(0).getValidator();
            csvTableValidator.setMandatoryFieldNames(tableValidator.getMandatoryFieldNames());
            csvTableValidator.setNotMadateFields(tableValidator.getNotMadateFields());
            csvTableValidator.setTableMandatory(tableValidator.getTableMandatory());
            boolean first = true;
            BigInteger[] sumVal = new BigInteger[4];
            sumVal[2] = sumVal[3] = BigInteger.ZERO;
            sumVal[1] = sumVal[3];
            sumVal[0] = sumVal[3];
            String line = br.readLine();
            if (line != null) {
                while ((line = br.readLine()) != null) {
                    String aadhaar;
                    String tin;
                    String passport;
                    String country;
                    String pan;
                    String panPassportTinType;
                    int[] array;
                    String amt;
                    String asmtYear;
                    line = CSVPluginOtherTables.getPrintableChar(line);
                    List<String> values = CSVPlugin.splitSimpleCSV(line);
                    if (tableId.equals("pt34aTable")) {
                        values = this.updateTheData(values);
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                    } else if (tableId.equals("form5Annex5pt1Table") || tableId.equals("form5Annex5pt2Table") || tableId.equals("form5Annex5pt3aTable") || tableId.equals("form5Annex5pt3bTable") || tableId.equals("form5Annex5pt3cTable") || tableId.equals("form5Annex5pt3dTable") || tableId.equals("form5Annex5pt4Table") || tableId.equals("form5Annex5pt5aTable") || tableId.equals("form5Annex5pt5bTable") || tableId.equals("form5Annex5pt5cTable") || tableId.equals("form5Annex5pt6Table")) {
                        values.add(values.size(), "0");
                    }
                    error = csvTableValidator.validate(values);
                    ++lineNo;
                    if (error != null) {
                        error = "Error at line no. " + (lineNo + 1) + ": " + error;
                        break;
                    }
                    if (tableId.equals("form5Annex5pt1Table")) {
                        asmtYear = values.get(10);
                        amt = values.get(11);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(8).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(9))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(11))));
                        array = new int[]{8, 9, 11};
                        values = this.calcAutopopulateValue(values, array, 12);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(12).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                        values = this.updateTheDataWithCountryName(values, 3);
                    } else if (tableId.equals("form5Annex5pt2Table")) {
                        asmtYear = values.get(10);
                        amt = values.get(11);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(8).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(9))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(11))));
                        array = new int[]{8, 9, 11};
                        values = this.calcAutopopulateValue(values, array, 12);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(12).trim()));
                        if (!values.get(0).trim().equals("Others")) {
                            values.set(1, "");
                        }
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                        values = this.updateTheDataWithCountryName(values, 3);
                    } else if (tableId.equals("form5Annex5pt3aTable")) {
                        asmtYear = values.get(5);
                        amt = values.get(6);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(3).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(4))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(6))));
                        array = new int[]{3, 4, 6};
                        values = this.calcAutopopulateValue(values, array, 7);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(7).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                    } else if (tableId.equals("form5Annex5pt3bTable")) {
                        asmtYear = values.get(6);
                        amt = values.get(7);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(4).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(5))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(7))));
                        array = new int[]{4, 5, 7};
                        values = this.calcAutopopulateValue(values, array, 8);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(8).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                    } else if (tableId.equals("form5Annex5pt3cTable")) {
                        asmtYear = values.get(2);
                        amt = values.get(3);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(0).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(1))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(3))));
                        array = new int[]{0, 1, 3};
                        values = this.calcAutopopulateValue(values, array, 4);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(4).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                    } else if (tableId.equals("form5Annex5pt3dTable")) {
                        asmtYear = values.get(2);
                        amt = values.get(3);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(0).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(1))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(3))));
                        array = new int[]{0, 1, 3};
                        values = this.calcAutopopulateValue(values, array, 4);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(4).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                    } else if (tableId.equals("form5Annex5pt4Table")) {
                        asmtYear = values.get(8);
                        amt = values.get(9);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(6).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(7))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(9))));
                        array = new int[]{6, 7, 9};
                        values = this.calcAutopopulateValue(values, array, 10);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(10).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                        values = this.updateTheDataWithCountryName(values, 1);
                    } else if (tableId.equals("form5Annex5pt5aTable")) {
                        asmtYear = values.get(12);
                        amt = values.get(13);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(10).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(11))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(13))));
                        array = new int[]{10, 11, 13};
                        values = this.calcAutopopulateValue(values, array, 14);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(14).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                        values = this.updateTheDataWithCountryName(values, 4);
                    } else if (tableId.equals("form5Annex5pt5bTable")) {
                        asmtYear = values.get(11);
                        amt = values.get(12);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(9).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(10))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(12))));
                        array = new int[]{9, 10, 12};
                        values = this.calcAutopopulateValue(values, array, 13);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(13).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                        values = this.updateTheDataWithCountryName(values, 3);
                    } else if (tableId.equals("form5Annex5pt5cTable")) {
                        asmtYear = values.get(11);
                        amt = values.get(12);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(9).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(10))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(12))));
                        array = new int[]{9, 10, 12};
                        values = this.calcAutopopulateValue(values, array, 13);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(13).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                        values = this.updateTheDataWithCountryName(values, 3);
                    } else if (tableId.equals("form5Annex5pt6Table")) {
                        asmtYear = values.get(7);
                        amt = values.get(8);
                        if (!asmtYear.equals("") && amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the amount of deduction on account of investment made in the asset during the previous year relevant to the assessment year for which a notice u/s 142/143(2)/148/153A/153C of the I.T. Act is issued";
                            break;
                        }
                        if (asmtYear.equals("") && !amt.equals("")) {
                            error = "Error at line no. " + (lineNo + 1) + ": Please enter the assessment year in YYYY-YY format starting from 1962-63";
                            break;
                        }
                        sumVal[0] = sumVal[0].add(new BigInteger(values.get(5).trim()));
                        sumVal[1] = sumVal[1].add(new BigInteger(this.coalesce(values.get(6))));
                        sumVal[2] = sumVal[2].add(new BigInteger(this.coalesce(values.get(8))));
                        array = new int[]{5, 6, 8};
                        values = this.calcAutopopulateValue(values, array, 9);
                        sumVal[3] = sumVal[3].add(new BigInteger(values.get(9).trim()));
                        line = CSVPlugin.joinSimpleCSV(values.toArray(new String[values.size()]));
                        values = this.updateTheDataWithCountryName(values, 1);
                    } else if (tableId.equals("form64Dpoint6Table")) {
                        panPassportTinType = values.get(2);
                        pan = values.get(3);
                        country = values.get(4);
                        passport = values.get(5);
                        tin = values.get(6);
                        aadhaar = values.get(7);
                        if (panPassportTinType.equals("PAN")) {
                            if (pan == null || pan.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the PAN";
                                break;
                            }
                            values.set(4, "");
                            values.set(5, "");
                            values.set(6, "");
                        } else if (panPassportTinType.equals("PASSPORT")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (passport == null || passport.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the passport Number";
                                break;
                            }
                            values.set(3, "");
                            values.set(6, "");
                        } else if (panPassportTinType.equals("TIN")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (tin == null || tin.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the TIN";
                                break;
                            }
                            values.set(3, "");
                            values.set(5, "");
                        } else if (panPassportTinType.equals("Aadhaar")) {
                            if (aadhaar == null || aadhaar.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Aadhaar";
                                break;
                            }
                            values.set(3, "");
                            values.set(4, "");
                            values.set(5, "");
                            values.set(6, "");
                        }
                        values = this.updateTheDataWithCountryName(values, 4);
                    } else if (tableId.equals("form64Dpt12Table")) {
                        System.out.println("Values: " + values);
                        panPassportTinType = values.get(2);
                        pan = values.get(3);
                        country = values.get(4);
                        passport = values.get(5);
                        tin = values.get(6);
                        aadhaar = values.get(7);
                        if (panPassportTinType.equals("PAN")) {
                            if (pan == null || pan.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the PAN";
                                break;
                            }
                            values.set(4, "");
                            values.set(5, "");
                            values.set(6, "");
                        } else if (panPassportTinType.equals("PASSPORT")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (passport == null || passport.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the passport Number";
                                break;
                            }
                            values.set(3, "");
                            values.set(6, "");
                        } else if (panPassportTinType.equals("TIN")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (tin == null || tin.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the TIN";
                                break;
                            }
                            values.set(3, "");
                            values.set(5, "");
                        } else if (panPassportTinType.equals("Aadhaar")) {
                            if (aadhaar == null || aadhaar.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Aadhaar";
                                break;
                            }
                            values.set(3, "");
                            values.set(4, "");
                            values.set(5, "");
                            values.set(6, "");
                        }
                        values = this.updateTheDataWithCountryName(values, 4);
                    } else if (tableId.equals("form64Dpt12iiTable")) {
                        panPassportTinType = values.get(2);
                        pan = values.get(3);
                        country = values.get(4);
                        passport = values.get(5);
                        tin = values.get(6);
                        aadhaar = values.get(7);
                        if (panPassportTinType.equals("PAN")) {
                            if (pan == null || pan.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the PAN";
                                break;
                            }
                            values.set(4, "");
                            values.set(5, "");
                            values.set(6, "");
                        } else if (panPassportTinType.equals("PASSPORT")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (passport == null || passport.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the passport Number";
                                break;
                            }
                            values.set(3, "");
                            values.set(6, "");
                        } else if (panPassportTinType.equals("TIN")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (tin == null || tin.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the TIN";
                                break;
                            }
                            values.set(3, "");
                            values.set(5, "");
                        } else if (panPassportTinType.equals("Aadhaar")) {
                            if (aadhaar == null || aadhaar.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Aadhaar";
                                break;
                            }
                            values.set(3, "");
                            values.set(4, "");
                            values.set(5, "");
                            values.set(6, "");
                        }
                        values = this.updateTheDataWithCountryName(values, 4);
                    } else if (tableId.equals("form64Dpt12iiiTable")) {
                        panPassportTinType = values.get(2);
                        pan = values.get(3);
                        country = values.get(5);
                        passport = values.get(6);
                        tin = values.get(7);
                        aadhaar = values.get(4);
                        if (panPassportTinType.equals("PAN")) {
                            if (pan == null || pan.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the PAN";
                                break;
                            }
                            values.set(4, "");
                            values.set(5, "");
                            values.set(6, "");
                            values.set(7, "");
                        } else if (panPassportTinType.equals("PASSPORT")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (passport == null || passport.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the passport Number";
                                break;
                            }
                            values.set(3, "");
                            values.set(4, "");
                            values.set(7, "");
                        } else if (panPassportTinType.equals("TIN")) {
                            if (country == null || country.trim().equals("") || country.equals("-1")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Country";
                                break;
                            }
                            if (tin == null || tin.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the TIN";
                                break;
                            }
                            values.set(3, "");
                            values.set(6, "");
                            values.set(4, "");
                        } else if (panPassportTinType.equals("Aadhaar")) {
                            if (aadhaar == null || aadhaar.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please enter the Aadhaar";
                                break;
                            }
                            values.set(3, "");
                            values.set(7, "");
                            values.set(5, "");
                            values.set(6, "");
                        }
                        values = this.updateTheDataWithCountryName(values, 5);
                    } else if (tableId.equals("pt34bTable")) {
                        System.out.println("Values: " + values);
                        String reportFlag = values.get(4);
                        String transDtls = values.get(5);
                        if (reportFlag.equals("N")) {
                            if (transDtls == null || transDtls.trim().equals("")) {
                                error = "Error at line no. " + (lineNo + 1) + ": Please Enter list of details/transactions which are not reported";
                                break;
                            }
                        } else if (reportFlag.equals("Y") && !transDtls.trim().equals("")) {
                            values.set(5, "");
                        }
                    }
                    String sumValString = CSVPlugin.joinSimpleCSV(sumVal);
                    map.put("sumVal", sumValString);
                    html.append("<tr style=\"display:none\"></tr>");
                    html.append("<tr><td id=\"" + lineNo + "\">" + lineNo + "</td>");
                    for (String val : values) {
                        html.append("<td>" + val + "</td>");
                    }
                    html.append("</tr>");
                    if (!first) {
                        bw.write("\n");
                    }
                    first = false;
                    bw.write(line);
                }
            }
            bw.close();
            br.close();
            map.put("lineNo", Integer.toString(lineNo));
            map.put("error", error);
            map.put("html", html.toString());
            if (ValidationUtil.isStringEmpty(error)) {
                tempImportedFiles.put(tableId, tmpFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private List<String> updateTheData(List<String> values) {
        String natOfPayment = this.getNatureOfPaymentForPt34aTable(values.get(1).trim());
        if (natOfPayment != null) {
            values.add(2, natOfPayment);
        } else {
            values.add(2, "Invalid section code");
        }
        return values;
    }

    private List<String> updateTheDataWithCountryName(List<String> values, int position) {
        if (values.get(position) == null) {
            return values;
        }
        if (values.get(position).trim().indexOf("others") != -1) {
            return values;
        }
        String countryName = this.getCountryName(values.get(position).trim());
        if (countryName != null) {
            values.set(position, countryName);
        } else {
            values.set(position, "Invalid country code");
        }
        return values;
    }

    private String getCountryName(String countryCode) {
        if (countryCode == null || countryCode.equals("-1")) {
            return "";
        }
        return CSVTableValidator.getCountryMap().get(countryCode);
    }

    private String getNatureOfPaymentForPt34aTable(String sectionCode) {
        return CSVTableValidator.getNatureOfPayments().get(sectionCode);
    }

    private boolean fillToTable(JSObject args, String actionType) {
        try {
            int len = (Integer)args.getMember("length");
            String[] strArgs = new String[len];
            JSObject jsdata = (JSObject)args.getSlot(0);
            ArrayList<String> data = new ArrayList<String>();
            for (int j = 0; j < (Integer)jsdata.getMember("length"); ++j) {
                data.add((String)jsdata.getSlot(j));
            }
            for (int i = 1; i < len; ++i) {
                strArgs[i - 1] = (String)args.getSlot(i);
            }
            Map<String, String> hashMap = this.importDataForTable(strArgs[0], strArgs[1], data, actionType);
            if (hashMap.get("error") == null) {
                MainController.itrEngine.executeScript("setCSVImportValues('" + strArgs[0] + "'," + hashMap.get("lineNo") + ",'" + hashMap.get("html") + "','fillData');");
                return true;
            }
            MainController.itrEngine.executeScript("showErrorMessage(\"" + hashMap.get("error") + "\");");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Map<String, String> importDataForTable(String tableId, String tablePrefix, List<String> data, String actionType) {
        int lineNo = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            File tmpFile = File.createTempFile("ITD", tableId);
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
            StringBuilder html = new StringBuilder();
            String error = null;
            CSVTableValidator csvTableValidator = new CSVTableValidator(tableId, tablePrefix);
            TableValidator tableValidator = (TableValidator)ValidationCacher.VALIDATION_MAP.get(tablePrefix).get(0).getValidator();
            csvTableValidator.setMandatoryFieldNames(tableValidator.getMandatoryFieldNames());
            csvTableValidator.setNotMadateFields(tableValidator.getNotMadateFields());
            csvTableValidator.setTableMandatory(tableValidator.getTableMandatory());
            boolean first = true;
            for (String line : data) {
                List<String> values = CSVPlugin.splitSimpleCSV(line);
                error = csvTableValidator.validate(values);
                ++lineNo;
                if (error != null) {
                    error = "Error at line no. " + lineNo + ": " + error;
                    break;
                }
                if (tableId.equals("form5Annex5pt1Table") || tableId.equals("form5Annex5pt2Table") || tableId.equals("form5Annex5pt4Table") || tableId.equals("form5Annex5pt5aTable") || tableId.equals("form5Annex5pt5bTable") || tableId.equals("form5Annex5pt5cTable") || tableId.equals("form5Annex5pt6Table") || tableId.equals("form64Dpoint6Table") || tableId.equals("form64Dpt12Table") || tableId.equals("form64Dpt12iiTable") || tableId.equals("form64Dpt12iiiTable")) {
                    int pos = csvTableValidator.getFields().indexOf("country");
                    values = this.updateTheDataWithCountryName(values, pos);
                }
                html.append("<tr style=\"display:none\"></tr>");
                html.append("<tr><td id=\"" + lineNo + "\">" + lineNo + "</td>");
                for (String val : values) {
                    html.append("<td>" + val + "</td>");
                }
                html.append("</tr>");
                if (!first) {
                    bw.write("\n");
                }
                first = false;
                bw.write(line);
            }
            bw.close();
            map.put("lineNo", Integer.toString(lineNo));
            map.put("error", error);
            map.put("html", html.toString());
            if (ValidationUtil.isStringEmpty(error)) {
                tempImportedFiles.put(tableId, tmpFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public void initFileChooser(String extension) {
        if (fileChooser == null) {
            fileChooser = new FileChooser();
            if (extension.equals(".csv")) {
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("CSV File (.csv)", new String[]{"*.csv"}));
            }
        }
    }

    private Object getFieldsFromFile(JSObject args) {
        String tableId = (String)args.getSlot(0);
        String tablePrefix = (String)args.getSlot(1);
        if ("reset".equals(tableId)) {
            rowAdded = 0;
            dummyRoot = null;
            return null;
        }
        LinkedHashMap fields = new LinkedHashMap();
        File tmpFile = tempImportedFiles.get(tableId);
        if (tmpFile != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(tmpFile));
                String xpath = ValidationCacher.getXPath(tablePrefix);
                NodeList nodeZero = (NodeList)ValidationCacher.xpath.evaluate(xpath, FormUtil.getXmlDoc(), XPathConstants.NODESET);
                Node root = nodeZero.item(0).getParentNode();
                int lineNo = 0;
                Node next = nodeZero.item(0).getNextSibling();
                while ((line = br.readLine()) != null) {
                    line = CSVPluginOtherTables.getPrintableChar(line);
                    ArrayList<String> values = CSVPlugin.splitSimpleCSV(line);
                    boolean i = false;
                    Node cloneNode = nodeZero.item(0);
                    if (lineNo > 0) {
                        cloneNode = nodeZero.item(0).cloneNode(true);
                        FormUtil.changeNodeAttr(cloneNode, (String)args.getSlot(2));
                        if (next != null) {
                            root.insertBefore(cloneNode, next);
                        } else {
                            root.appendChild(cloneNode);
                        }
                    }
                    this.setNodeValues(cloneNode, values, 0);
                    ++lineNo;
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fields;
    }

    public int setNodeValues(Node cloneNode, List<String> values, int i) {
        for (int j = 1; j < cloneNode.getChildNodes().getLength(); ++j) {
            if (i >= values.size()) {
                return i;
            }
            if (cloneNode.getChildNodes().item(j).getNodeType() == 3) continue;
            if (cloneNode.getChildNodes().item(j).getAttributes().getNamedItem("name") != null) {
                String val;
                if ((val = values.get(i++)) != null && val.length() != 0 && val.matches("^[0-9]{2}(/)[0-9]{2}(/)[0-9]{4}$")) {
                    val = val.substring(6) + "-" + val.substring(3, 5) + "-" + val.substring(0, 2);
                }
                cloneNode.getChildNodes().item(j).setTextContent(val);
                continue;
            }
            i = this.setNodeValues(cloneNode.getChildNodes().item(j), values, i);
        }
        return i;
    }

    private Object saveFieldsInFile(JSObject args) {
        try {
            tableValueMatrix.clear();
            Document doc = FormUtil.getImportXmlDoc();
            if (doc == null) {
                return null;
            }
            NodeList rootNodes = (NodeList)ValidationCacher.xpath.evaluate(ValidationCacher.XPATH_TO_FIELD.get(args.getSlot(1)), doc, XPathConstants.NODESET);
            int rootLen = rootNodes.getLength();
            if (rootLen == 0) {
                return null;
            }
            String tableId = null;
            for (int i = 0; i < rootLen; ++i) {
                NodeList nodeList = rootNodes.item(i).getChildNodes();
                int nodeLength = nodeList.getLength();
                String[] matrix = null;
                String[] tags = null;
                Node childNode = null;
                int l = 0;
                for (int j = 0; j < nodeLength; ++j) {
                    childNode = nodeList.item(j);
                    if (tableId == null) {
                        if (childNode.getFirstChild() == null) continue;
                        String type = childNode.getFirstChild().getTextContent();
                        tableId = ValidationCacher.XPATH_TO_FIELD.get(ValidationCacher.XPATH_TO_FIELD.get(args.getSlot(1)) + "/" + type);
                        tags = ((String)CSVTableValidator.getCsvProperties().get(tableId + "_Tags")).split(",");
                        matrix = new String[((String)CSVTableValidator.getCsvProperties().get(tableId)).split(",").length];
                        continue;
                    }
                    if (this.hasChilds(childNode)) {
                        for (int m = 0; m < childNode.getChildNodes().getLength(); ++m) {
                            if (childNode.getChildNodes().item(m).getNodeType() == 3) continue;
                            while (!CSVPluginOtherTables.removeNameSpacePrefix(childNode.getChildNodes().item(m).getNodeName(), (String)tags[l])) {
                                matrix[l++] = null;
                            }
                            matrix[l++] = this.modifyData(childNode.getChildNodes().item(m).getTextContent());
                        }
                        continue;
                    }
                    if (childNode.getNodeType() == 3) continue;
                    if (childNode.getFirstChild() != null) {
                        while (!CSVPluginOtherTables.removeNameSpacePrefix(childNode.getNodeName(), (String)tags[l])) {
                            matrix[l++] = null;
                        }
                        matrix[l++] = this.modifyData(childNode.getFirstChild().getTextContent());
                        continue;
                    }
                    ++l;
                }
                if (tableValueMatrix.get(tableId) != null) {
                    tableValueMatrix.get(tableId).add(matrix);
                } else {
                    ArrayList<String[]> valueMatrixAdd = new ArrayList<String[]>();
                    valueMatrixAdd.add(matrix);
                    tableValueMatrix.put(tableId, valueMatrixAdd);
                }
                tableId = null;
            }
            for (int j = 0; j < rootLen; ++j) {
                rootNodes.item(j).getParentNode().removeChild(rootNodes.item(j));
            }
            Set<String> keys = tableValueMatrix.keySet();
            for (String table : keys) {
                List<String[]> valueMatrix = tableValueMatrix.get(table);
                if (valueMatrix == null) continue;
                File tmpFile = File.createTempFile("ITD", table);
                BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
                StringBuilder html = new StringBuilder();
                int lineNo = 1;
                boolean first = true;
                for (String[] str : valueMatrix) {
                    String line = CSVPlugin.joinSimpleCSV(str);
                    html.append("<tr style=\"display:none\"></tr>");
                    html.append("<tr><td id=\"" + lineNo + "\">" + lineNo++ + "</td>");
                    for (String val : str) {
                        if (val == null) {
                            html.append("<td></td>");
                            continue;
                        }
                        html.append("<td>" + val + "</td>");
                    }
                    html.append("</tr>");
                    if (!first) {
                        bw.write("\n");
                    }
                    first = false;
                    bw.write(line);
                }
                bw.close();
                tempImportedFiles.put(table, tmpFile);
                MainController.getInstance().getItrEngine().executeScript("displayFieldsInHtml('" + html + "','" + table + "');");
            }
            tableValueMatrix.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object saveFieldsInFileCustom(JSObject args) {
        try {
            tableValueMatrix.clear();
            Document doc = FormUtil.getImportXmlDoc();
            if (doc == null) {
                return null;
            }
            NodeList rootNodes = (NodeList)ValidationCacher.xpath.evaluate(ValidationCacher.XPATH_TO_FIELD.get(args.getSlot(1)), doc, XPathConstants.NODESET);
            int rootLen = rootNodes.getLength();
            if (rootLen == 0) {
                return null;
            }
            String tableId = null;
            for (int i = 0; i < rootLen; ++i) {
                NodeList nodeList = rootNodes.item(i).getChildNodes();
                int nodeLength = nodeList.getLength();
                String[] matrix = null;
                String[] tags = null;
                Node childNode = null;
                int l = 0;
                for (int j = 0; j < nodeLength; ++j) {
                    childNode = nodeList.item(j);
                    if (tableId == null) {
                        if (childNode.getFirstChild() != null) {
                            String type = childNode.getFirstChild().getNextSibling().getFirstChild().getTextContent();
                            tableId = ValidationCacher.XPATH_TO_FIELD.get(ValidationCacher.XPATH_TO_FIELD.get(args.getSlot(1)) + "/" + type);
                            tags = ((String)CSVTableValidator.getCsvProperties().get(tableId + "_Tags")).split(",");
                            matrix = new String[((String)CSVTableValidator.getCsvProperties().get(tableId)).split(",").length];
                        }
                        if (tableId == null) continue;
                        ++j;
                        continue;
                    }
                    if (this.hasChilds(childNode)) {
                        for (int m = 0; m < childNode.getChildNodes().getLength(); ++m) {
                            if (childNode.getChildNodes().item(m).getNodeType() == 3) continue;
                            while (!CSVPluginOtherTables.removeNameSpacePrefix(childNode.getChildNodes().item(m).getNodeName(), (String)tags[l])) {
                                matrix[l++] = null;
                            }
                            matrix[l++] = this.modifyData(childNode.getChildNodes().item(m).getTextContent());
                        }
                        continue;
                    }
                    if (childNode.getNodeType() == 3) continue;
                    if (childNode.getFirstChild() != null) {
                        while (!CSVPluginOtherTables.removeNameSpacePrefix(childNode.getNodeName(), (String)tags[l])) {
                            matrix[l++] = null;
                        }
                        matrix[l++] = this.modifyData(childNode.getFirstChild().getTextContent());
                        continue;
                    }
                    ++l;
                }
                if (tableValueMatrix.get(tableId) != null) {
                    tableValueMatrix.get(tableId).add(matrix);
                } else {
                    ArrayList<String[]> valueMatrixAdd = new ArrayList<String[]>();
                    valueMatrixAdd.add(matrix);
                    tableValueMatrix.put(tableId, valueMatrixAdd);
                }
                tableId = null;
            }
            for (int j = 0; j < rootLen; ++j) {
                rootNodes.item(j).getParentNode().removeChild(rootNodes.item(j));
            }
            Set<String> keys = tableValueMatrix.keySet();
            for (String table : keys) {
                List<String[]> valueMatrix = tableValueMatrix.get(table);
                if (valueMatrix == null) continue;
                File tmpFile = File.createTempFile("ITD", table);
                BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
                StringBuilder html = new StringBuilder();
                int lineNo = 1;
                boolean first = true;
                for (String[] str : valueMatrix) {
                    String line = CSVPlugin.joinSimpleCSV(str);
                    html.append("<tr style=\"display:none\"></tr>");
                    html.append("<tr><td id=\"" + lineNo + "\">" + lineNo++ + "</td>");
                    for (String val : str) {
                        if (val == null) {
                            html.append("<td></td>");
                            continue;
                        }
                        html.append("<td>" + val + "</td>");
                    }
                    html.append("</tr>");
                    if (!first) {
                        bw.write("\n");
                    }
                    first = false;
                    bw.write(line);
                }
                bw.close();
                tempImportedFiles.put(table, tmpFile);
                MainController.getInstance().getItrEngine().executeScript("displayFieldsInHtml('" + html + "','" + table + "');");
            }
            tableValueMatrix.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Object saveFieldsOtherInFile(JSObject args) {
        try {
            tableValueMatrix.clear();
            Document doc = FormUtil.getImportXmlDoc();
            if (doc == null) {
                return null;
            }
            NodeList rootNodes = (NodeList)ValidationCacher.xpath.evaluate(ValidationCacher.XPATH_TO_FIELD.get(args.getSlot(1)), doc, XPathConstants.NODESET);
            int rootLen = rootNodes.getLength();
            if (rootLen == 0) {
                return null;
            }
            String tableId = null;
            for (int i = 0; i < rootLen; ++i) {
                NodeList nodeList = rootNodes.item(i).getChildNodes();
                int nodeLength = nodeList.getLength();
                String[] matrix = null;
                String[] tags = null;
                Node childNode = null;
                int l = 0;
                for (int j = 0; j < nodeLength; ++j) {
                    childNode = nodeList.item(j);
                    if (tableId == null && childNode.getFirstChild() != null) {
                        tableId = ValidationCacher.XPATH_TO_FIELD.get(ValidationCacher.XPATH_TO_FIELD.get(args.getSlot(1)));
                        tags = ((String)CSVTableValidator.getCsvProperties().get(tableId + "_Tags")).split(",");
                        matrix = new String[((String)CSVTableValidator.getCsvProperties().get(tableId)).split(",").length];
                    }
                    if (this.hasChilds(childNode)) {
                        for (int m = 0; m < childNode.getChildNodes().getLength(); ++m) {
                            if (childNode.getChildNodes().item(m).getNodeType() == 3) continue;
                            while (!CSVPluginOtherTables.removeNameSpacePrefix(childNode.getChildNodes().item(m).getNodeName(), tags[l])) {
                                matrix[l++] = null;
                            }
                            matrix[l++] = this.modifyData(childNode.getChildNodes().item(m).getTextContent());
                        }
                        continue;
                    }
                    if (childNode.getNodeType() == 3) continue;
                    if (childNode.getFirstChild() != null) {
                        while (!CSVPluginOtherTables.removeNameSpacePrefix(childNode.getNodeName(), (String)tags[l])) {
                            matrix[l++] = null;
                        }
                        matrix[l++] = this.modifyData(childNode.getFirstChild().getTextContent());
                        continue;
                    }
                    ++l;
                }
                if (tableValueMatrix.get(tableId) != null) {
                    tableValueMatrix.get(tableId).add(matrix);
                } else {
                    ArrayList<String[]> valueMatrixAdd = new ArrayList<String[]>();
                    valueMatrixAdd.add(matrix);
                    tableValueMatrix.put(tableId, valueMatrixAdd);
                }
                tableId = null;
            }
            for (int j = 0; j < rootLen; ++j) {
                rootNodes.item(j).getParentNode().removeChild(rootNodes.item(j));
            }
            Set<String> keys = tableValueMatrix.keySet();
            for (String table : keys) {
                List<String[]> valueMatrix = tableValueMatrix.get(table);
                if (valueMatrix == null || valueMatrix.get(0) == null) continue;
                File tmpFile = File.createTempFile("ITD", table);
                BufferedWriter bw = new BufferedWriter(new FileWriter(tmpFile));
                StringBuilder html = new StringBuilder();
                int lineNo = 1;
                boolean first = true;
                html.append("<tr style=\"display:none\"></tr>");
                for (String[] str : valueMatrix) {
                    List<String> str1;
                    String line = CSVPlugin.joinSimpleCSV(str);
                    if (args.getSlot(1).equals("form.form6.form6Entity.formBankAccDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 3);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form6.form6Entity.formImmPropertyDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 3);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form6.form6Entity.formArtWorkDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 1);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form6.form6Entity.formQuotedSharesDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 4);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form6.form6Entity.formUnQuotedEquityDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 3);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form6.form6Entity.formUnQuotedSharesDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 3);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form6.form6Entity.formOthAssetDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 1);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form64D.form64DEntity.form10daDtl")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 4);
                        str = (String[])str1.toArray();
                    } else if (args.getSlot(1).equals("form.form64D.form64DEntity.unitHolderDtls")) {
                        str1 = this.updateTheDataWithCountryName(Arrays.asList(str), 4);
                        str = (String[])str1.toArray();
                    }
                    html.append("<tr><td id=\"" + lineNo + "\">" + lineNo++ + "</td>");
                    for (String val : str) {
                        if (val == null) {
                            html.append("<td></td>");
                            continue;
                        }
                        html.append("<td>" + val + "</td>");
                    }
                    html.append("</tr>");
                    if (!first) {
                        bw.write("\n");
                    }
                    first = false;
                    bw.write(line);
                }
                bw.close();
                tempImportedFiles.put(table, tmpFile);
                MainController.getInstance().getItrEngine().executeScript("displayFieldsInHtml('" + html + "','" + table + "');");
            }
            tableValueMatrix.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean removeNameSpacePrefix(String nodeName, String tagName) {
        String node = nodeName.substring(nodeName.indexOf(":") + 1, nodeName.length());
        return !ValidationUtil.isStringEmpty(node) && node.equals(tagName);
    }

    private String modifyData(String textContent) {
        if (!ValidationUtil.isStringEmpty(textContent)) {
            if (textContent.matches("^[0-9]{4}(-)[0-9]{2}(-)[0-9]{2}$")) {
                textContent = textContent.substring(8) + "/" + textContent.substring(5, 7) + "/" + textContent.substring(0, 4);
            } else if (textContent.matches("^[A-Za-z]{5}[0-9]{4}[A-Za-z]{1}$") || textContent.matches("^[A-Za-z]{4}[0-9]{5}[A-Za-z]{1}$")) {
                textContent = textContent.toUpperCase();
            }
        }
        return textContent;
    }

    public boolean hasChilds(Node node) {
        NodeList childs = node.getChildNodes();
        int childLength = childs.getLength();
        for (int i = 0; i < childLength; ++i) {
            if (childs.item(i).getNodeType() == 3) continue;
            return true;
        }
        return false;
    }

    public Object displayCSVInstructions(JSObject args) {
        try {
            String tableId = (String)args.getSlot(0);
            InputStream templateFile = CSVPluginOtherTables.getInstructionsPage(tableId);
            Document newDoc = FormCacher.getDocument(templateFile);
            String string = MainController.getInstance().getItrName();
            String string2 = MainController.getInstance().getAsstYear();
            MainController.getInstance();
            File tempFile = FormConfigUtil.getHtmlTempFile(string, string2, MainController.getVersion());
            FormUtil.writeHtmlToFile(tempFile, newDoc);
            PreviewUtil.print(tempFile);
            MainController.getInstance().generateErrorDialog(FormConfigUtil.getConfigProperty("msg.csv.instructions"), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public static InputStream getInstructionsPage(String tableId) {
        String path = null;
        if (tableId.equals("pt18Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Depr_CSV_Instructions.html").toString();
        } else if (tableId.equals("pt21biaTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Tds_CSV_Instructions.html").toString();
        } else if (tableId.equals("pt21biiaLevyTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instructions_21b_iii_A.html").toString();
        } else if (tableId.equals("pt21biibLevyTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instructions_21b_iii_B.html").toString();
        } else if (tableId.equals("pt20Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_20(b).html").toString();
        } else if (tableId.equals("pt34cTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_34c.html").toString();
        } else if (tableId.equals("pt31aTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_31a.html").toString();
        } else if (tableId.equals("pt31bTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_31b.html").toString();
        } else if (tableId.equals("pt34bTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_34b.html").toString();
        } else if (tableId.equals("pt26iAaTable") || tableId.equals("pt26iAbTable") || tableId.equals("pt26iBaTable") || tableId.equals("pt26iBbTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_26.html").toString();
        } else if (tableId.equals("pt34aTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_34a.html").toString();
        } else if (tableId.equals("pt35bATable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_35bA.html").toString();
        } else if (tableId.equals("pt35bBTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_35bB.html").toString();
        } else if (tableId.equals("pt35bCTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_35bC.html").toString();
        } else if (tableId.equals("pt15Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_point15.html").toString();
        } else if (tableId.equals("pt5Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/Instruction_point5.html").toString();
        } else if (tableId.equals("form5Annex5pt1Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point1.html").toString();
        } else if (tableId.equals("form5Annex5pt2Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point2.html").toString();
        } else if (tableId.equals("form5Annex5pt4Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point4.html").toString();
        } else if (tableId.equals("form5Annex5pt5aTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point5a.html").toString();
        } else if (tableId.equals("form5Annex5pt5bTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point5b.html").toString();
        } else if (tableId.equals("form5Annex5pt5cTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point5c.html").toString();
        } else if (tableId.equals("form5Annex5pt6Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point6.html").toString();
        } else if (tableId.equals("form5Annex5pt3aTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point3a.html").toString();
        } else if (tableId.equals("form5Annex5pt3bTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point3b.html").toString();
        } else if (tableId.equals("form5Annex5pt3cTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point3c.html").toString();
        } else if (tableId.equals("form5Annex5pt3dTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM6_Instruction_Point3d.html").toString();
        } else if (tableId.equals("form64Dpoint6Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM64D_Instruction_Point6.html").toString();
        } else if (tableId.equals("form64Dpt12Table")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM64D_Instruction_Point10.html").toString();
        } else if (tableId.equals("form64Dpt12iiTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM64D_Instruction_Point10.html").toString();
        } else if (tableId.equals("form64Dpt12iiiTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM64D_Instruction_Point10.html").toString();
        } else if (tableId.equals("form64ETrusteeTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM64E_Instruction_Trustee.html").toString();
        } else if (tableId.equals("form64EInvestorTable")) {
            StringBuilder stringBuilder = new StringBuilder().append(FormConfigUtil.getActulaJarPath()).append("/").append(MainController.getInstance().getItrName()).append("/").append(MainController.getInstance().getAsstYear()).append("/");
            MainController.getInstance();
            path = stringBuilder.append(MainController.getVersion()).append("/CSV_Instructions/FORM64E_Instruction_UnitInvestor.html").toString();
        }
        return FormConfigUtil.getResourceStream(path);
    }

    private Object deleteCSVFile(JSObject args) {
        try {
            String tableId = (String)args.getSlot(0);
            tempImportedFiles.remove(tableId);
        }
        catch (Exception e) {
            System.out.println("exex::" + e);
        }
        return true;
    }

    public static String getPrintableChar(String field) {
        String finalField = field;
        char[] saras = field.toCharArray();
        for (int i = 0; i < saras.length; ++i) {
            if (CSVPluginOtherTables.isPrintableChar(saras[i])) continue;
            finalField = field.replace(saras[i], ' ');
        }
        finalField = finalField.replace('\u201d', ' ');
        finalField = finalField.replace('\u201c', ' ');
        return finalField;
    }

    public static boolean isPrintableChar(char field) {
        char saras = field;
        return saras >= ' ' && saras <= '~';
    }

    public String coalesce(String value) {
        if (value.isEmpty() || value == "") {
            value = "0";
        }
        return value.trim();
    }

    public List<String> calcAutopopulateValue(List<String> values, int[] positions, int target) {
        long total = 0L;
        total = Long.parseLong(this.coalesce(values.get(positions[0]))) - Long.parseLong(this.coalesce(values.get(positions[1]))) - Long.parseLong(this.coalesce(values.get(positions[2])));
        total = Math.max(0L, total);
        values.set(target, Long.toString(total));
        return values;
    }

    static {
        tempImportedFiles = new HashMap<String, File>();
        tableValueMatrix = new HashMap<String, List<String[]>>();
        dummyRoot = null;
        rowAdded = 0;
    }
}

