/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.plugins.csv;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.ValidationCacher;
import com.tcs.efiling.form.validation.main.FieldValidatorRoot;
import com.tcs.efiling.form.validation.main.ValidationException;
import com.tcs.efiling.form.validation.main.ValidationUtil;
import com.tcs.efiling.form.validation.main.Validator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class CSVTableValidator {
    private static Properties csvProperties;
    private String mandatoryFieldNames;
    private String tableMandatory;
    private String notMadateFields;
    private List<String> fields;
    private String[] displayFields;
    private String tablePrefix;
    private Validator validator = new Validator();
    private static Map<String, String> natureOfPayments;
    private static Map<String, String> countryMap;

    public CSVTableValidator(String tableId, String tablePrefix) {
        this.tablePrefix = tablePrefix;
        this.fields = Arrays.asList(((String)csvProperties.get(tableId)).split(","));
        this.validator.setMainController(MainController.getInstance());
    }

    public String validate(List<String> values) {
        String error = null;
        if (this.fields.size() != values.size()) {
            error = this.fields.size() + " columns expected. " + values.size() + " columns found";
        }
        if (error == null) {
            String[] madateFields = this.mandatoryFieldNames.split(",");
            String val1 = null;
            String name = null;
            for (String s : madateFields) {
                name = this.tablePrefix + "." + s;
                int pos = this.fields.indexOf(s);
                val1 = values.get(pos);
                if (!ValidationUtil.isStringEmpty(val1)) continue;
                error = ValidationCacher.getError(name + ".required");
                break;
            }
        }
        if (error == null) {
            String name = null;
            int count = 0;
            for (String field : this.fields) {
                name = this.tablePrefix + "[0]." + field.trim();
                List<FieldValidatorRoot> root = ValidationCacher.VALIDATION_MAP.get(name);
                if (root != null) {
                    for (FieldValidatorRoot validatorRoot : root) {
                        try {
                            validatorRoot.getValidator().resetHasErrors();
                            validatorRoot.getValidator().validate(values.get(count), name, this.validator);
                            if (!validatorRoot.getValidator().hasErrors()) continue;
                            this.validator.removeErrors(name);
                            error = " At column No: " + (count + 1) + " " + ValidationCacher.getError(validatorRoot.getValidator().getErrorCode());
                            break;
                        }
                        catch (ValidationException e) {
                            e.printStackTrace();
                        }
                    }
                    if (error != null) {
                        break;
                    }
                } else {
                    System.out.println("No validator for : " + name);
                }
                ++count;
            }
        }
        return error;
    }

    public boolean checkSumOfAmountsinRange(long sumOfAmounts, Long TotalAmt) {
        boolean equal = false;
        if (TotalAmt >= sumOfAmounts - 2L && TotalAmt <= sumOfAmounts + 2L || TotalAmt <= 0L && sumOfAmounts < 0L) {
            equal = true;
        }
        return equal;
    }

    public CSVTableValidator(String mandatoryFieldNames, String tableMandatory, String notMadateFields) {
        this.mandatoryFieldNames = mandatoryFieldNames;
        this.tableMandatory = tableMandatory;
        this.notMadateFields = notMadateFields;
    }

    public String getMandatoryFieldNames() {
        return this.mandatoryFieldNames;
    }

    public void setMandatoryFieldNames(String mandatoryFieldNames) {
        this.mandatoryFieldNames = mandatoryFieldNames;
    }

    public String getTableMandatory() {
        return this.tableMandatory;
    }

    public void setTableMandatory(String tableMandatory) {
        this.tableMandatory = tableMandatory;
    }

    public String getNotMadateFields() {
        return this.notMadateFields;
    }

    public void setNotMadateFields(String notMadateFields) {
        this.notMadateFields = notMadateFields;
    }

    private static void loadProps() {
        MainController currentInstance = MainController.getInstance();
        if (csvProperties == null) {
            csvProperties = new Properties();
            try {
                csvProperties.load(FormConfigUtil.getCSVImportPath(currentInstance.getItrName(), currentInstance.getAsstYear(), currentInstance.getVersion()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadPt34aNatureOfPayments() {
        natureOfPayments.put("192", "Salary");
        natureOfPayments.put("192A", "Payment of accumulated balance due to an employee");
        natureOfPayments.put("193", "Interest on securities");
        natureOfPayments.put("194", "Dividends");
        natureOfPayments.put("194A", "Interest other than Interest on securities");
        natureOfPayments.put("194B", "Winnings from lottery or crossword puzzle");
        natureOfPayments.put("194BB", "Winnings from horse race");
        natureOfPayments.put("194C", "Payments to contractors");
        natureOfPayments.put("194D", "Insurance commission");
        natureOfPayments.put("194DA", "Payment in respect of Life Insurance Companies");
        natureOfPayments.put("194E", "Payments to non-resident sportsmen or sports associations");
        natureOfPayments.put("194EE", "Payments in respect of deposits under National Savings Scheme etc");
        natureOfPayments.put("194F", "Payments on account of repurchase of units by Mutual Fund or Unit Trust of India");
        natureOfPayments.put("194G", "Commission etc. on the sale of lottery tickets.");
        natureOfPayments.put("194H", "Commission or brokerage");
        natureOfPayments.put("194-I", "Rent");
        natureOfPayments.put("194-IA", "Payment on transfer of certain immovable property other than agricultural land");
        natureOfPayments.put("194-IB", "Payment of rent by certain individuals or Hindu undivided family");
        natureOfPayments.put("194-IC", "Payment under specified agreement");
        natureOfPayments.put("194J", "Fees for professional or technical services");
        natureOfPayments.put("194K", "Income in respect of units");
        natureOfPayments.put("194L", "Payment of compensation on acquisition of capital asset");
        natureOfPayments.put("194LA", "Payment of compensation on acquisition of certain immovable property");
        natureOfPayments.put("194LB", "Income by way of interest from infrastructure debt fund");
        natureOfPayments.put("194LBA", "Certain income from units of a business trust");
        natureOfPayments.put("194LBB", "Income in respect of units of investment fund");
        natureOfPayments.put("194LBC", "Income in respect of investment in securitization trust");
        natureOfPayments.put("194LC", "Income by way of interest from Indian company");
        natureOfPayments.put("194LD", "Income by way of interest on certain bonds and Government securities");
        natureOfPayments.put("194M", "Payment of certain sums referred in section 194C or 194D or 194H or 194J by Individual or HUF");
        natureOfPayments.put("194N", "Payment of amount in cash");
        natureOfPayments.put("195", "Other sums");
        natureOfPayments.put("196A", "Income in respect of units of non-residents");
        natureOfPayments.put("196B", "Income from units");
        natureOfPayments.put("196C", "Income from foreign currency bonds or shares of Indian company");
        natureOfPayments.put("196D", "Income of Foreign Institutional Investors from securities");
        natureOfPayments.put("206C", "Profits and gains from the business of trading in alcoholic liquor and forest produce and scrap etc");
        natureOfPayments.put("OTH", "Others");
    }

    private static void loadCountryMap() {
        countryMap.put("", "");
        countryMap.put("93", "AFGHANISTAN");
        countryMap.put("1001", "\u00c5LAND ISLANDS");
        countryMap.put("355", "ALBANIA");
        countryMap.put("213", "ALGERIA");
        countryMap.put("684", "AMERICAN SAMOA");
        countryMap.put("376", "ANDORRA");
        countryMap.put("244", "ANGOLA");
        countryMap.put("1264", "ANGUILLA");
        countryMap.put("1010", "ANTARCTICA");
        countryMap.put("1268", "ANTIGUA AND BARBUDA");
        countryMap.put("54", "ARGENTINA");
        countryMap.put("374", "ARMENIA");
        countryMap.put("297", "ARUBA");
        countryMap.put("61", "AUSTRALIA");
        countryMap.put("43", "AUSTRIA");
        countryMap.put("994", "AZERBAIJAN");
        countryMap.put("1242", "BAHAMAS");
        countryMap.put("973", "BAHRAIN");
        countryMap.put("880", "BANGLADESH");
        countryMap.put("1246", "BARBADOS");
        countryMap.put("375", "BELARUS");
        countryMap.put("32", "BELGIUM");
        countryMap.put("501", "BELIZE");
        countryMap.put("229", "BENIN");
        countryMap.put("1441", "BERMUDA");
        countryMap.put("975", "BHUTAN");
        countryMap.put("591", "BOLIVIA (PLURINATIONAL STATE OF)");
        countryMap.put("1002", "BONAIRE, SINT EUSTATIUS AND SABA");
        countryMap.put("387", "BOSNIA AND HERZEGOVINA");
        countryMap.put("267", "BOTSWANA");
        countryMap.put("1003", "BOUVET ISLAND");
        countryMap.put("55", "BRAZIL");
        countryMap.put("1014", "BRITISH INDIAN OCEAN TERRITORY");
        countryMap.put("673", "BRUNEI DARUSSALAM");
        countryMap.put("359", "BULGARIA");
        countryMap.put("226", "BURKINA FASO");
        countryMap.put("257", "BURUNDI");
        countryMap.put("238", "CABO VERDE");
        countryMap.put("855", "CAMBODIA");
        countryMap.put("237", "CAMEROON");
        countryMap.put("1", "CANADA");
        countryMap.put("1345", "CAYMAN ISLANDS");
        countryMap.put("236", "CENTRAL AFRICAN REPUBLIC");
        countryMap.put("235", "CHAD");
        countryMap.put("56", "CHILE");
        countryMap.put("86", "CHINA");
        countryMap.put("9", "CHRISTMAS ISLAND");
        countryMap.put("672", "COCOS (KEELING) ISLANDS");
        countryMap.put("57", "COLOMBIA");
        countryMap.put("270", "COMOROS");
        countryMap.put("242", "CONGO");
        countryMap.put("243", "CONGO (DEMOCRATIC REPUBLIC OF THE)");
        countryMap.put("682", "COOK ISLANDS");
        countryMap.put("506", "COSTA RICA");
        countryMap.put("225", "C\u00d4TE D IVOIRE");
        countryMap.put("385", "CROATIA");
        countryMap.put("53", "CUBA");
        countryMap.put("1015", "CURA\u00c7AO");
        countryMap.put("357", "CYPRUS");
        countryMap.put("420", "CZECHIA");
        countryMap.put("45", "DENMARK");
        countryMap.put("253", "DJIBOUTI");
        countryMap.put("1767", "DOMINICA");
        countryMap.put("1809", "DOMINICAN REPUBLIC");
        countryMap.put("593", "ECUADOR");
        countryMap.put("20", "EGYPT");
        countryMap.put("503", "EL SALVADOR");
        countryMap.put("240", "EQUATORIAL GUINEA");
        countryMap.put("291", "ERITREA");
        countryMap.put("372", "ESTONIA");
        countryMap.put("251", "ETHIOPIA");
        countryMap.put("500", "FALKLAND ISLANDS (MALVINAS)");
        countryMap.put("298", "FAROE ISLANDS");
        countryMap.put("679", "FIJI");
        countryMap.put("358", "FINLAND");
        countryMap.put("33", "FRANCE");
        countryMap.put("594", "FRENCH GUIANA");
        countryMap.put("689", "FRENCH POLYNESIA");
        countryMap.put("1004", "FRENCH SOUTHERN TERRITORIES");
        countryMap.put("241", "GABON");
        countryMap.put("220", "GAMBIA");
        countryMap.put("995", "GEORGIA");
        countryMap.put("49", "GERMANY");
        countryMap.put("233", "GHANA");
        countryMap.put("350", "GIBRALTAR");
        countryMap.put("30", "GREECE");
        countryMap.put("299", "GREENLAND");
        countryMap.put("1473", "GRENADA");
        countryMap.put("590", "GUADELOUPE");
        countryMap.put("1671", "GUAM");
        countryMap.put("502", "GUATEMALA");
        countryMap.put("1481", "GUERNSEY");
        countryMap.put("224", "GUINEA");
        countryMap.put("245", "GUINEA-BISSAU");
        countryMap.put("592", "GUYANA");
        countryMap.put("509", "HAITI");
        countryMap.put("1005", "HEARD ISLAND AND MCDONALD ISLANDS");
        countryMap.put("6", "HOLY SEE");
        countryMap.put("504", "HONDURAS");
        countryMap.put("852", "HONG KONG");
        countryMap.put("36", "HUNGARY");
        countryMap.put("354", "ICELAND");
        countryMap.put("91", "INDIA");
        countryMap.put("62", "INDONESIA");
        countryMap.put("98", "IRAN (ISLAMIC REPUBLIC OF)");
        countryMap.put("964", "IRAQ");
        countryMap.put("353", "IRELAND");
        countryMap.put("1624", "ISLE OF MAN");
        countryMap.put("972", "ISRAEL");
        countryMap.put("5", "ITALY");
        countryMap.put("1876", "JAMAICA");
        countryMap.put("81", "JAPAN");
        countryMap.put("1534", "JERSEY");
        countryMap.put("962", "JORDAN");
        countryMap.put("7", "KAZAKHSTAN");
        countryMap.put("254", "KENYA");
        countryMap.put("686", "KIRIBATI");
        countryMap.put("850", "KOREA (DEMOCRATIC PEOPLE S REPUBLIC OF)");
        countryMap.put("82", "KOREA (REPUBLIC OF)");
        countryMap.put("965", "KUWAIT");
        countryMap.put("996", "KYRGYZSTAN");
        countryMap.put("856", "LAO PEOPLE S DEMOCRATIC REPUBLIC");
        countryMap.put("371", "LATVIA");
        countryMap.put("961", "LEBANON");
        countryMap.put("266", "LESOTHO");
        countryMap.put("231", "LIBERIA");
        countryMap.put("218", "LIBYA");
        countryMap.put("423", "LIECHTENSTEIN");
        countryMap.put("370", "LITHUANIA");
        countryMap.put("352", "LUXEMBOURG");
        countryMap.put("853", "MACAO");
        countryMap.put("389", "MACEDONIA (THE FORMER YUGOSLAV REPUBLIC OF)");
        countryMap.put("261", "MADAGASCAR");
        countryMap.put("265", "MALAWI");
        countryMap.put("60", "MALAYSIA");
        countryMap.put("960", "MALDIVES");
        countryMap.put("223", "MALI");
        countryMap.put("356", "MALTA");
        countryMap.put("692", "MARSHALL ISLANDS");
        countryMap.put("596", "MARTINIQUE");
        countryMap.put("222", "MAURITANIA");
        countryMap.put("230", "MAURITIUS");
        countryMap.put("269", "MAYOTTE");
        countryMap.put("52", "MEXICO");
        countryMap.put("691", "MICRONESIA (FEDERATED STATES OF)");
        countryMap.put("373", "MOLDOVA (REPUBLIC OF)");
        countryMap.put("377", "MONACO");
        countryMap.put("976", "MONGOLIA");
        countryMap.put("382", "MONTENEGRO");
        countryMap.put("1664", "MONTSERRAT");
        countryMap.put("212", "MOROCCO");
        countryMap.put("258", "MOZAMBIQUE");
        countryMap.put("95", "MYANMAR");
        countryMap.put("264", "NAMIBIA");
        countryMap.put("674", "NAURU");
        countryMap.put("977", "NEPAL");
        countryMap.put("31", "NETHERLANDS");
        countryMap.put("687", "NEW CALEDONIA");
        countryMap.put("64", "NEW ZEALAND");
        countryMap.put("505", "NICARAGUA");
        countryMap.put("227", "NIGER");
        countryMap.put("234", "NIGERIA");
        countryMap.put("683", "NIUE");
        countryMap.put("15", "NORFOLK ISLAND");
        countryMap.put("1670", "NORTHERN MARIANA ISLANDS");
        countryMap.put("47", "NORWAY");
        countryMap.put("968", "OMAN");
        countryMap.put("92", "PAKISTAN");
        countryMap.put("680", "PALAU");
        countryMap.put("970", "PALESTINE, STATE OF");
        countryMap.put("507", "PANAMA");
        countryMap.put("675", "PAPUA NEW GUINEA");
        countryMap.put("595", "PARAGUAY");
        countryMap.put("51", "PERU");
        countryMap.put("63", "PHILIPPINES");
        countryMap.put("1011", "PITCAIRN");
        countryMap.put("48", "POLAND");
        countryMap.put("14", "PORTUGAL");
        countryMap.put("1787", "PUERTO RICO");
        countryMap.put("974", "QATAR");
        countryMap.put("262", "R\u00c9UNION");
        countryMap.put("40", "ROMANIA");
        countryMap.put("8", "RUSSIAN FEDERATION");
        countryMap.put("250", "RWANDA");
        countryMap.put("1006", "SAINT BARTH\u00c9LEMY");
        countryMap.put("290", "SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA");
        countryMap.put("1869", "SAINT KITTS AND NEVIS");
        countryMap.put("1758", "SAINT LUCIA");
        countryMap.put("1007", "SAINT MARTIN (FRENCH PART)");
        countryMap.put("508", "SAINT PIERRE AND MIQUELON");
        countryMap.put("1784", "SAINT VINCENT AND THE GRENADINES");
        countryMap.put("685", "SAMOA");
        countryMap.put("378", "SAN MARINO");
        countryMap.put("239", "SAO TOME AND PRINCIPE");
        countryMap.put("966", "SAUDI ARABIA");
        countryMap.put("221", "SENEGAL");
        countryMap.put("381", "SERBIA");
        countryMap.put("248", "SEYCHELLES");
        countryMap.put("232", "SIERRA LEONE");
        countryMap.put("65", "SINGAPORE");
        countryMap.put("1721", "SINT MAARTEN (DUTCH PART)");
        countryMap.put("421", "SLOVAKIA");
        countryMap.put("386", "SLOVENIA");
        countryMap.put("677", "SOLOMON ISLANDS");
        countryMap.put("252", "SOMALIA");
        countryMap.put("28", "SOUTH AFRICA");
        countryMap.put("1008", "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS");
        countryMap.put("211", "SOUTH SUDAN");
        countryMap.put("35", "SPAIN");
        countryMap.put("94", "SRI LANKA");
        countryMap.put("249", "SUDAN");
        countryMap.put("597", "SURINAME");
        countryMap.put("1012", "SVALBARD AND JAN MAYEN");
        countryMap.put("268", "SWAZILAND");
        countryMap.put("46", "SWEDEN");
        countryMap.put("41", "SWITZERLAND");
        countryMap.put("963", "SYRIAN ARAB REPUBLIC");
        countryMap.put("886", "TAIWAN, PROVINCE OF CHINA[A]");
        countryMap.put("992", "TAJIKISTAN");
        countryMap.put("255", "TANZANIA, UNITED REPUBLIC OF");
        countryMap.put("66", "THAILAND");
        countryMap.put("670", "TIMOR-LESTE (EAST TIMOR)");
        countryMap.put("228", "TOGO");
        countryMap.put("690", "TOKELAU");
        countryMap.put("676", "TONGA");
        countryMap.put("1868", "TRINIDAD AND TOBAGO");
        countryMap.put("216", "TUNISIA");
        countryMap.put("90", "TURKEY");
        countryMap.put("993", "TURKMENISTAN");
        countryMap.put("1649", "TURKS AND CAICOS ISLANDS");
        countryMap.put("688", "TUVALU");
        countryMap.put("256", "UGANDA");
        countryMap.put("380", "UKRAINE");
        countryMap.put("971", "UNITED ARAB EMIRATES");
        countryMap.put("44", "UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND");
        countryMap.put("2", "UNITED STATES OF AMERICA");
        countryMap.put("1009", "UNITED STATES MINOR OUTLYING ISLANDS");
        countryMap.put("598", "URUGUAY");
        countryMap.put("998", "UZBEKISTAN");
        countryMap.put("678", "VANUATU");
        countryMap.put("58", "VENEZUELA (BOLIVARIAN REPUBLIC OF)");
        countryMap.put("84", "VIET NAM");
        countryMap.put("1284", "VIRGIN ISLANDS (BRITISH)");
        countryMap.put("1340", "VIRGIN ISLANDS (U.S.)");
        countryMap.put("681", "WALLIS AND FUTUNA");
        countryMap.put("1013", "WESTERN SAHARA");
        countryMap.put("967", "YEMEN");
        countryMap.put("260", "ZAMBIA");
        countryMap.put("263", "ZIMBABWE");
        countryMap.put("9999", "OTHERS");
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String[] getDisplayFields() {
        return this.displayFields;
    }

    public void setDisplayFields(String[] displayFields) {
        this.displayFields = displayFields;
    }

    public static Properties getCsvProperties() {
        return csvProperties;
    }

    public static void setCsvProperties(Properties csvProperties) {
        CSVTableValidator.csvProperties = csvProperties;
    }

    public static Map<String, String> getNatureOfPayments() {
        return natureOfPayments;
    }

    public static void setNatureOfPayments(Map<String, String> natureOfPayments) {
        CSVTableValidator.natureOfPayments = natureOfPayments;
    }

    public static Map<String, String> getCountryMap() {
        return countryMap;
    }

    public static void setCountryMap(Map<String, String> countryMap) {
        CSVTableValidator.countryMap = countryMap;
    }

    static {
        natureOfPayments = new HashMap<String, String>();
        countryMap = new HashMap<String, String>();
        CSVTableValidator.loadProps();
        CSVTableValidator.loadPt34aNatureOfPayments();
        CSVTableValidator.loadCountryMap();
    }
}

